/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.util.Objects;
import org.neo4j.causalclustering.catchup.RequestMessageType;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.CatchUpRequest;

public class TxPullRequest
implements CatchUpRequest {
    private long previousTxId;
    private final StoreId expectedStoreId;

    public TxPullRequest(long previousTxId, StoreId expectedStoreId) {
        this.previousTxId = previousTxId;
        this.expectedStoreId = expectedStoreId;
    }

    public long previousTxId() {
        return this.previousTxId;
    }

    public StoreId expectedStoreId() {
        return this.expectedStoreId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxPullRequest that = (TxPullRequest)o;
        return this.previousTxId == that.previousTxId && Objects.equals(this.expectedStoreId, that.expectedStoreId);
    }

    public int hashCode() {
        return Objects.hash(this.previousTxId, this.expectedStoreId);
    }

    public String toString() {
        return String.format("TxPullRequest{txId=%d, storeId=%s}", this.previousTxId, this.expectedStoreId);
    }

    @Override
    public RequestMessageType messageType() {
        return RequestMessageType.TX_PULL_REQUEST;
    }
}

