/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;

public interface RaftMessages {

    public static abstract class BaseRaftMessage
    implements RaftMessage {
        protected final MemberId from;
        private final Type type;

        BaseRaftMessage(MemberId from, Type type) {
            this.from = from;
            this.type = type;
        }

        @Override
        public MemberId from() {
            return this.from;
        }

        @Override
        public Type type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseRaftMessage that = (BaseRaftMessage)o;
            return Objects.equals(this.from, that.from) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.from, this.type});
        }
    }

    public static class PruneRequest
    extends BaseRaftMessage {
        private final long pruneIndex;

        public PruneRequest(long pruneIndex) {
            super(null, Type.PRUNE_REQUEST);
            this.pruneIndex = pruneIndex;
        }

        public long pruneIndex() {
            return this.pruneIndex;
        }

        @Override
        public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
            return handler.handle(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PruneRequest that = (PruneRequest)o;
            return this.pruneIndex == that.pruneIndex;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.pruneIndex);
        }
    }

    public static class ReceivedInstantClusterIdAwareMessageImpl<RM extends RaftMessage>
    implements ReceivedInstantClusterIdAwareMessage<RM> {
        private final Instant receivedAt;
        private final ClusterId clusterId;
        private final RM message;

        private ReceivedInstantClusterIdAwareMessageImpl(Instant receivedAt, ClusterId clusterId, RM message) {
            Objects.requireNonNull(message);
            this.clusterId = clusterId;
            this.receivedAt = receivedAt;
            this.message = message;
        }

        @Override
        public Instant receivedAt() {
            return this.receivedAt;
        }

        @Override
        public ClusterId clusterId() {
            return this.clusterId;
        }

        @Override
        public RM message() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReceivedInstantClusterIdAwareMessageImpl that = (ReceivedInstantClusterIdAwareMessageImpl)o;
            return Objects.equals(this.receivedAt, that.receivedAt) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.message(), that.message());
        }

        public int hashCode() {
            return Objects.hash(this.receivedAt, this.clusterId, this.message());
        }

        public String toString() {
            return String.format("{clusterId: %s, receivedAt: %s, message: %s}", this.clusterId, this.receivedAt, this.message());
        }

        /* synthetic */ ReceivedInstantClusterIdAwareMessageImpl(Instant x0, ClusterId x1, RaftMessage x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class ReceivedInstantAwareMessageImpl<RM extends RaftMessage>
    implements ReceivedInstantAwareMessage<RM> {
        private final Instant receivedAt;
        private final RM message;

        private ReceivedInstantAwareMessageImpl(Instant receivedAt, RM message) {
            Objects.requireNonNull(message);
            this.receivedAt = receivedAt;
            this.message = message;
        }

        @Override
        public Instant receivedAt() {
            return this.receivedAt;
        }

        @Override
        public RM message() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReceivedInstantAwareMessageImpl that = (ReceivedInstantAwareMessageImpl)o;
            return Objects.equals(this.receivedAt, that.receivedAt) && Objects.equals(this.message(), that.message());
        }

        public int hashCode() {
            return Objects.hash(this.receivedAt, this.message());
        }

        public String toString() {
            return String.format("{receivedAt: %s, message: %s}", this.receivedAt, this.message());
        }

        /* synthetic */ ReceivedInstantAwareMessageImpl(Instant x0, RaftMessage x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class ClusterIdAwareMessageImpl<RM extends RaftMessage>
    implements ClusterIdAwareMessage<RM> {
        private final ClusterId clusterId;
        private final RM message;

        private ClusterIdAwareMessageImpl(ClusterId clusterId, RM message) {
            Objects.requireNonNull(message);
            this.clusterId = clusterId;
            this.message = message;
        }

        @Override
        public ClusterId clusterId() {
            return this.clusterId;
        }

        @Override
        public RM message() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterIdAwareMessageImpl that = (ClusterIdAwareMessageImpl)o;
            return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.message(), that.message());
        }

        public int hashCode() {
            return Objects.hash(this.clusterId, this.message());
        }

        public String toString() {
            return String.format("{clusterId: %s, message: %s}", this.clusterId, this.message());
        }

        /* synthetic */ ClusterIdAwareMessageImpl(ClusterId x0, RaftMessage x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static interface ReceivedInstantClusterIdAwareMessage<RM extends RaftMessage>
    extends ReceivedInstantAwareMessage<RM>,
    ClusterIdAwareMessage<RM> {
        public static <RM extends RaftMessage> ReceivedInstantClusterIdAwareMessage<RM> of(Instant receivedAt, ClusterId clusterId, RM message) {
            return new ReceivedInstantClusterIdAwareMessageImpl(receivedAt, clusterId, message, null);
        }
    }

    public static interface ReceivedInstantAwareMessage<RM extends RaftMessage>
    extends EnrichedRaftMessage<RM> {
        public Instant receivedAt();

        public static <RM extends RaftMessage> ReceivedInstantAwareMessage<RM> of(Instant receivedAt, RM message) {
            return new ReceivedInstantAwareMessageImpl(receivedAt, message, null);
        }
    }

    public static interface ClusterIdAwareMessage<RM extends RaftMessage>
    extends EnrichedRaftMessage<RM> {
        public ClusterId clusterId();

        public static <RM extends RaftMessage> ClusterIdAwareMessage<RM> of(ClusterId clusterId, RM message) {
            return new ClusterIdAwareMessageImpl(clusterId, message, null);
        }
    }

    public static interface EnrichedRaftMessage<RM extends RaftMessage>
    extends RaftMessage {
        public RM message();

        @Override
        default public MemberId from() {
            return this.message().from();
        }

        @Override
        default public Type type() {
            return this.message().type();
        }

        @Override
        default public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
            return this.message().dispatch(handler);
        }
    }

    public static interface NewEntry {

        public static class BatchRequest
        extends BaseRaftMessage {
            private List<ReplicatedContent> list;

            public BatchRequest(int batchSize) {
                super(null, Type.NEW_BATCH_REQUEST);
                this.list = new ArrayList<ReplicatedContent>(batchSize);
            }

            public void add(ReplicatedContent content) {
                this.list.add(content);
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                BatchRequest batchRequest = (BatchRequest)o;
                return Objects.equals(this.list, batchRequest.list);
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.list);
            }

            public String toString() {
                return "BatchRequest{list=" + this.list + '}';
            }

            public List<ReplicatedContent> contents() {
                return Collections.unmodifiableList(this.list);
            }
        }

        public static class Request
        extends BaseRaftMessage {
            private ReplicatedContent content;

            public Request(MemberId from, ReplicatedContent content) {
                super(from, Type.NEW_ENTRY_REQUEST);
                this.content = content;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            public String toString() {
                return String.format("NewEntry.Request from %s {content=%s}", this.from, this.content);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Request request = (Request)o;
                return !(this.content == null ? request.content != null : !this.content.equals(request.content));
            }

            @Override
            public int hashCode() {
                return this.content != null ? this.content.hashCode() : 0;
            }

            public ReplicatedContent content() {
                return this.content;
            }
        }
    }

    public static interface Timeout {

        public static class Heartbeat
        extends BaseRaftMessage {
            public Heartbeat(MemberId from) {
                super(from, Type.HEARTBEAT_TIMEOUT);
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            public String toString() {
                return "Timeout.Heartbeat{}";
            }
        }

        public static class Election
        extends BaseRaftMessage {
            public Election(MemberId from) {
                super(from, Type.ELECTION_TIMEOUT);
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            public String toString() {
                return "Timeout.Election{}";
            }
        }
    }

    public static class LogCompactionInfo
    extends BaseRaftMessage {
        private long leaderTerm;
        private long prevIndex;

        public LogCompactionInfo(MemberId from, long leaderTerm, long prevIndex) {
            super(from, Type.LOG_COMPACTION_INFO);
            this.leaderTerm = leaderTerm;
            this.prevIndex = prevIndex;
        }

        public long leaderTerm() {
            return this.leaderTerm;
        }

        public long prevIndex() {
            return this.prevIndex;
        }

        @Override
        public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
            return handler.handle(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LogCompactionInfo other = (LogCompactionInfo)o;
            return this.leaderTerm == other.leaderTerm && this.prevIndex == other.prevIndex;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.leaderTerm ^ this.leaderTerm >>> 32);
            result = 31 * result + (int)(this.prevIndex ^ this.prevIndex >>> 32);
            return result;
        }

        public String toString() {
            return String.format("Log compaction from %s {leaderTerm=%d, prevIndex=%d}", this.from, this.leaderTerm, this.prevIndex);
        }
    }

    public static class HeartbeatResponse
    extends BaseRaftMessage {
        public HeartbeatResponse(MemberId from) {
            super(from, Type.HEARTBEAT_RESPONSE);
        }

        @Override
        public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
            return handler.handle(this);
        }

        public String toString() {
            return "HeartbeatResponse{from=" + this.from + "}";
        }
    }

    public static class Heartbeat
    extends BaseRaftMessage {
        private long leaderTerm;
        private long commitIndex;
        private long commitIndexTerm;

        public Heartbeat(MemberId from, long leaderTerm, long commitIndex, long commitIndexTerm) {
            super(from, Type.HEARTBEAT);
            this.leaderTerm = leaderTerm;
            this.commitIndex = commitIndex;
            this.commitIndexTerm = commitIndexTerm;
        }

        public long leaderTerm() {
            return this.leaderTerm;
        }

        public long commitIndex() {
            return this.commitIndex;
        }

        public long commitIndexTerm() {
            return this.commitIndexTerm;
        }

        @Override
        public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
            return handler.handle(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Heartbeat heartbeat = (Heartbeat)o;
            return this.leaderTerm == heartbeat.leaderTerm && this.commitIndex == heartbeat.commitIndex && this.commitIndexTerm == heartbeat.commitIndexTerm;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.leaderTerm ^ this.leaderTerm >>> 32);
            result = 31 * result + (int)(this.commitIndex ^ this.commitIndex >>> 32);
            result = 31 * result + (int)(this.commitIndexTerm ^ this.commitIndexTerm >>> 32);
            return result;
        }

        public String toString() {
            return String.format("Heartbeat from %s {leaderTerm=%d, commitIndex=%d, commitIndexTerm=%d}", this.from, this.leaderTerm, this.commitIndex, this.commitIndexTerm);
        }
    }

    public static interface AppendEntries {

        public static class Response
        extends BaseRaftMessage {
            private long term;
            private boolean success;
            private long matchIndex;
            private long appendIndex;

            public Response(MemberId from, long term, boolean success, long matchIndex, long appendIndex) {
                super(from, Type.APPEND_ENTRIES_RESPONSE);
                this.term = term;
                this.success = success;
                this.matchIndex = matchIndex;
                this.appendIndex = appendIndex;
            }

            public long term() {
                return this.term;
            }

            public boolean success() {
                return this.success;
            }

            public long matchIndex() {
                return this.matchIndex;
            }

            public long appendIndex() {
                return this.appendIndex;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Response response = (Response)o;
                return this.term == response.term && this.success == response.success && this.matchIndex == response.matchIndex && this.appendIndex == response.appendIndex;
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.term, this.success, this.matchIndex, this.appendIndex);
            }

            public String toString() {
                return String.format("AppendEntries.Response from %s {term=%d, success=%s, matchIndex=%d, appendIndex=%d}", this.from, this.term, this.success, this.matchIndex, this.appendIndex);
            }
        }

        public static class Request
        extends BaseRaftMessage {
            private long leaderTerm;
            private long prevLogIndex;
            private long prevLogTerm;
            private RaftLogEntry[] entries;
            private long leaderCommit;

            public Request(MemberId from, long leaderTerm, long prevLogIndex, long prevLogTerm, RaftLogEntry[] entries, long leaderCommit) {
                super(from, Type.APPEND_ENTRIES_REQUEST);
                Objects.requireNonNull(entries);
                assert (!(prevLogIndex == -1L && prevLogTerm != -1L || prevLogTerm == -1L && prevLogIndex != -1L)) : String.format("prevLogIndex was %d and prevLogTerm was %d", prevLogIndex, prevLogTerm);
                this.entries = entries;
                this.leaderTerm = leaderTerm;
                this.prevLogIndex = prevLogIndex;
                this.prevLogTerm = prevLogTerm;
                this.leaderCommit = leaderCommit;
            }

            public long leaderTerm() {
                return this.leaderTerm;
            }

            public long prevLogIndex() {
                return this.prevLogIndex;
            }

            public long prevLogTerm() {
                return this.prevLogTerm;
            }

            public RaftLogEntry[] entries() {
                return this.entries;
            }

            public long leaderCommit() {
                return this.leaderCommit;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Request request = (Request)o;
                return Objects.equals(this.leaderTerm, request.leaderTerm) && Objects.equals(this.prevLogIndex, request.prevLogIndex) && Objects.equals(this.prevLogTerm, request.prevLogTerm) && Objects.equals(this.leaderCommit, request.leaderCommit) && Arrays.equals(this.entries, request.entries);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.leaderTerm, this.prevLogIndex, this.prevLogTerm, Arrays.hashCode(this.entries), this.leaderCommit);
            }

            public String toString() {
                return String.format("AppendEntries.Request from %s {leaderTerm=%d, prevLogIndex=%d, prevLogTerm=%d, entry=%s, leaderCommit=%d}", this.from, this.leaderTerm, this.prevLogIndex, this.prevLogTerm, Arrays.toString(this.entries), this.leaderCommit);
            }
        }
    }

    public static interface PreVote {

        public static class Response
        extends BaseRaftMessage
        implements AnyVote.Response {
            private long term;
            private boolean voteGranted;

            public Response(MemberId from, long term, boolean voteGranted) {
                super(from, Type.PRE_VOTE_RESPONSE);
                this.term = term;
                this.voteGranted = voteGranted;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Response response = (Response)o;
                return this.term == response.term && this.voteGranted == response.voteGranted;
            }

            @Override
            public int hashCode() {
                int result = (int)this.term;
                result = 31 * result + (this.voteGranted ? 1 : 0);
                return result;
            }

            public String toString() {
                return String.format("PreVote.Response from %s {term=%d, voteGranted=%s}", this.from, this.term, this.voteGranted);
            }

            @Override
            public long term() {
                return this.term;
            }

            @Override
            public boolean voteGranted() {
                return this.voteGranted;
            }
        }

        public static class Request
        extends BaseRaftMessage
        implements AnyVote.Request {
            private long term;
            private MemberId candidate;
            private long lastLogIndex;
            private long lastLogTerm;

            public Request(MemberId from, long term, MemberId candidate, long lastLogIndex, long lastLogTerm) {
                super(from, Type.PRE_VOTE_REQUEST);
                this.term = term;
                this.candidate = candidate;
                this.lastLogIndex = lastLogIndex;
                this.lastLogTerm = lastLogTerm;
            }

            @Override
            public long term() {
                return this.term;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Request request = (Request)o;
                return this.lastLogIndex == request.lastLogIndex && this.lastLogTerm == request.lastLogTerm && this.term == request.term && this.candidate.equals(request.candidate);
            }

            @Override
            public int hashCode() {
                int result = (int)this.term;
                result = 31 * result + this.candidate.hashCode();
                result = 31 * result + (int)(this.lastLogIndex ^ this.lastLogIndex >>> 32);
                result = 31 * result + (int)(this.lastLogTerm ^ this.lastLogTerm >>> 32);
                return result;
            }

            public String toString() {
                return String.format("PreVote.Request from %s {term=%d, candidate=%s, lastAppended=%d, lastLogTerm=%d}", this.from, this.term, this.candidate, this.lastLogIndex, this.lastLogTerm);
            }

            @Override
            public long lastLogTerm() {
                return this.lastLogTerm;
            }

            @Override
            public long lastLogIndex() {
                return this.lastLogIndex;
            }

            @Override
            public MemberId candidate() {
                return this.candidate;
            }
        }
    }

    public static interface Vote {

        public static class Response
        extends BaseRaftMessage
        implements AnyVote.Response {
            private long term;
            private boolean voteGranted;

            public Response(MemberId from, long term, boolean voteGranted) {
                super(from, Type.VOTE_RESPONSE);
                this.term = term;
                this.voteGranted = voteGranted;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Response response = (Response)o;
                return this.term == response.term && this.voteGranted == response.voteGranted;
            }

            @Override
            public int hashCode() {
                int result = (int)this.term;
                result = 31 * result + (this.voteGranted ? 1 : 0);
                return result;
            }

            public String toString() {
                return String.format("Vote.Response from %s {term=%d, voteGranted=%s}", this.from, this.term, this.voteGranted);
            }

            @Override
            public long term() {
                return this.term;
            }

            @Override
            public boolean voteGranted() {
                return this.voteGranted;
            }
        }

        public static class Request
        extends BaseRaftMessage
        implements AnyVote.Request {
            private long term;
            private MemberId candidate;
            private long lastLogIndex;
            private long lastLogTerm;

            public Request(MemberId from, long term, MemberId candidate, long lastLogIndex, long lastLogTerm) {
                super(from, Type.VOTE_REQUEST);
                this.term = term;
                this.candidate = candidate;
                this.lastLogIndex = lastLogIndex;
                this.lastLogTerm = lastLogTerm;
            }

            @Override
            public long term() {
                return this.term;
            }

            @Override
            public <T, E extends Exception> T dispatch(Handler<T, E> handler) throws E {
                return handler.handle(this);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Request request = (Request)o;
                return this.lastLogIndex == request.lastLogIndex && this.lastLogTerm == request.lastLogTerm && this.term == request.term && this.candidate.equals(request.candidate);
            }

            @Override
            public int hashCode() {
                int result = (int)this.term;
                result = 31 * result + this.candidate.hashCode();
                result = 31 * result + (int)(this.lastLogIndex ^ this.lastLogIndex >>> 32);
                result = 31 * result + (int)(this.lastLogTerm ^ this.lastLogTerm >>> 32);
                return result;
            }

            public String toString() {
                return String.format("Vote.Request from %s {term=%d, candidate=%s, lastAppended=%d, lastLogTerm=%d}", this.from, this.term, this.candidate, this.lastLogIndex, this.lastLogTerm);
            }

            @Override
            public long lastLogTerm() {
                return this.lastLogTerm;
            }

            @Override
            public long lastLogIndex() {
                return this.lastLogIndex;
            }

            @Override
            public MemberId candidate() {
                return this.candidate;
            }
        }
    }

    public static interface AnyVote {

        public static interface Response {
            public long term();

            public boolean voteGranted();
        }

        public static interface Request {
            public long term();

            public long lastLogTerm();

            public long lastLogIndex();

            public MemberId candidate();
        }
    }

    public static class Directed {
        MemberId to;
        RaftMessage message;

        public Directed(MemberId to, RaftMessage message) {
            this.to = to;
            this.message = message;
        }

        public MemberId to() {
            return this.to;
        }

        public RaftMessage message() {
            return this.message;
        }

        public String toString() {
            return String.format("Directed{to=%s, message=%s}", this.to, this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Directed directed = (Directed)o;
            return Objects.equals(this.to, directed.to) && Objects.equals(this.message, directed.message);
        }

        public int hashCode() {
            return Objects.hash(this.to, this.message);
        }
    }

    public static interface RaftMessage
    extends Message {
        public MemberId from();

        public Type type();

        public <T, E extends Exception> T dispatch(Handler<T, E> var1) throws E;
    }

    public static enum Type {
        VOTE_REQUEST,
        VOTE_RESPONSE,
        APPEND_ENTRIES_REQUEST,
        APPEND_ENTRIES_RESPONSE,
        HEARTBEAT,
        HEARTBEAT_RESPONSE,
        LOG_COMPACTION_INFO,
        ELECTION_TIMEOUT,
        HEARTBEAT_TIMEOUT,
        NEW_ENTRY_REQUEST,
        NEW_BATCH_REQUEST,
        PRUNE_REQUEST,
        PRE_VOTE_REQUEST,
        PRE_VOTE_RESPONSE;

    }

    public static interface Handler<T, E extends Exception> {
        public T handle(Vote.Request var1) throws E;

        public T handle(Vote.Response var1) throws E;

        public T handle(PreVote.Request var1) throws E;

        public T handle(PreVote.Response var1) throws E;

        public T handle(AppendEntries.Request var1) throws E;

        public T handle(AppendEntries.Response var1) throws E;

        public T handle(Heartbeat var1) throws E;

        public T handle(LogCompactionInfo var1) throws E;

        public T handle(HeartbeatResponse var1) throws E;

        public T handle(Timeout.Election var1) throws E;

        public T handle(Timeout.Heartbeat var1) throws E;

        public T handle(NewEntry.Request var1) throws E;

        public T handle(NewEntry.BatchRequest var1) throws E;

        public T handle(PruneRequest var1) throws E;
    }
}

