/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ProtocolSelection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.stream.Streams;

public abstract class ProtocolRepository<U extends Comparable<U>, T extends Protocol<U>> {
    private final Map<Pair<String, U>, T> protocolMap;
    private final BiFunction<String, Set<U>, ProtocolSelection<U, T>> protocolSelectionFactory;
    private Function<String, Comparator<T>> comparator;

    public ProtocolRepository(T[] protocols, Function<String, Comparator<T>> comparators, BiFunction<String, Set<U>, ProtocolSelection<U, T>> protocolSelectionFactory) {
        this.protocolSelectionFactory = protocolSelectionFactory;
        HashMap<Pair, T> map = new HashMap<Pair, T>();
        for (T protocol : protocols) {
            Protocol previous = (Protocol)map.put(Pair.of((Object)protocol.category(), protocol.implementation()), protocol);
            if (previous == null) continue;
            throw new IllegalArgumentException(String.format("Multiple protocols with same identifier and version supplied: %s and %s", protocol, previous));
        }
        this.protocolMap = Collections.unmodifiableMap(map);
        this.comparator = comparators;
    }

    Optional<T> select(String protocolName, U version) {
        return Optional.ofNullable(this.protocolMap.get(Pair.of((Object)protocolName, version)));
    }

    Optional<T> select(String protocolName, Set<U> versions) {
        return versions.stream().map(version -> this.select(protocolName, version)).flatMap(Streams::ofOptional).max(this.comparator.apply(protocolName));
    }

    public ProtocolSelection<U, T> getAll(Protocol.Category<T> category, Collection<U> versions) {
        Set selectedVersions = this.protocolMap.entrySet().stream().map(Map.Entry::getKey).filter(pair -> ((String)pair.first()).equals(category.canonicalName())).map(Pair::other).filter(version -> versions.isEmpty() || versions.contains(version)).collect(Collectors.toSet());
        if (selectedVersions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Attempted to select protocols for %s versions %s but no match in known protocols %s", category, versions, this.protocolMap));
        }
        return this.protocolSelectionFactory.apply(category.canonicalName(), selectedVersions);
    }

    static <U extends Comparable<U>, T extends Protocol<U>> Comparator<T> versionNumberComparator() {
        return Comparator.comparing(Protocol::implementation);
    }
}

