/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.IOException;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.DatabaseShutdownException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.core.state.snapshot.TopologyLookupException;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReadReplicaStartupProcess
implements Lifecycle {
    private final RemoteStore remoteStore;
    private final LocalDatabase localDatabase;
    private final Lifecycle txPulling;
    private final Log debugLog;
    private final Log userLog;
    private final TimeoutStrategy timeoutStrategy;
    private final UpstreamDatabaseStrategySelector selectionStrategyPipeline;
    private final TopologyService topologyService;
    private String lastIssue;
    private final StoreCopyProcess storeCopyProcess;

    ReadReplicaStartupProcess(RemoteStore remoteStore, LocalDatabase localDatabase, Lifecycle txPulling, UpstreamDatabaseStrategySelector selectionStrategyPipeline, TimeoutStrategy timeoutStrategy, LogProvider debugLogProvider, LogProvider userLogProvider, StoreCopyProcess storeCopyProcess, TopologyService topologyService) {
        this.remoteStore = remoteStore;
        this.localDatabase = localDatabase;
        this.txPulling = txPulling;
        this.selectionStrategyPipeline = selectionStrategyPipeline;
        this.timeoutStrategy = timeoutStrategy;
        this.debugLog = debugLogProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.storeCopyProcess = storeCopyProcess;
        this.topologyService = topologyService;
    }

    public void init() throws Throwable {
        this.localDatabase.init();
        this.txPulling.init();
    }

    private String issueOf(String operation, int attempt) {
        return String.format("Failed attempt %d of %s", attempt, operation);
    }

    public void start() throws IOException, DatabaseShutdownException {
        boolean syncedWithUpstream = false;
        TimeoutStrategy.Timeout timeout = this.timeoutStrategy.newTimeout();
        int attempt = 0;
        while (!syncedWithUpstream) {
            ++attempt;
            MemberId source = null;
            try {
                source = this.selectionStrategyPipeline.bestUpstreamDatabase();
                this.syncStoreWithUpstream(source);
                syncedWithUpstream = true;
            }
            catch (UpstreamDatabaseSelectionException e) {
                this.lastIssue = this.issueOf("finding upstream member", attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (StoreCopyFailedException e) {
                this.lastIssue = this.issueOf(String.format("copying store files from %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (StoreIdDownloadFailedException e) {
                this.lastIssue = this.issueOf(String.format("getting store id from %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (TopologyLookupException e) {
                this.lastIssue = this.issueOf(String.format("getting address of %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            try {
                Thread.sleep(timeout.getMillis());
                timeout.increment();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.lastIssue = "Interrupted while trying to start read replica";
                this.debugLog.warn(this.lastIssue);
                break;
            }
        }
        if (!syncedWithUpstream) {
            this.userLog.error(this.lastIssue);
            throw new RuntimeException(this.lastIssue);
        }
        try {
            this.localDatabase.start();
            this.txPulling.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void syncStoreWithUpstream(MemberId source) throws IOException, StoreIdDownloadFailedException, StoreCopyFailedException, TopologyLookupException, DatabaseShutdownException {
        if (this.localDatabase.isEmpty()) {
            this.debugLog.info("Local database is empty, attempting to replace with copy from upstream server %s", new Object[]{source});
            this.debugLog.info("Finding store id of upstream server %s", new Object[]{source});
            AdvertisedSocketAddress fromAddress = this.topologyService.findCatchupAddress(source).orElseThrow(() -> new TopologyLookupException(source));
            StoreId storeId = this.remoteStore.getStoreId(fromAddress);
            this.debugLog.info("Copying store from upstream server %s", new Object[]{source});
            this.localDatabase.delete();
            CatchupAddressProvider.UpstreamStrategyBoundAddressProvider addressProvider = new CatchupAddressProvider.UpstreamStrategyBoundAddressProvider(this.topologyService, this.selectionStrategyPipeline);
            this.storeCopyProcess.replaceWithStoreFrom(addressProvider, storeId);
            this.debugLog.info("Restarting local database after copy.", new Object[]{source});
        } else {
            this.ensureSameStoreIdAs(source);
        }
    }

    private void ensureSameStoreIdAs(MemberId upstream) throws StoreIdDownloadFailedException, TopologyLookupException {
        AdvertisedSocketAddress advertisedSocketAddress;
        StoreId remoteStoreId;
        StoreId localStoreId = this.localDatabase.storeId();
        if (!localStoreId.equals(remoteStoreId = this.remoteStore.getStoreId(advertisedSocketAddress = this.topologyService.findCatchupAddress(upstream).orElseThrow(() -> new TopologyLookupException(upstream))))) {
            throw new IllegalStateException(String.format("This read replica cannot join the cluster. The local database is not empty and has a mismatching storeId: expected %s actual %s.", remoteStoreId, localStoreId));
        }
    }

    public void stop() throws Throwable {
        this.txPulling.stop();
        this.localDatabase.stop();
    }

    public void shutdown() throws Throwable {
        this.txPulling.shutdown();
        this.localDatabase.shutdown();
    }
}

