/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstance;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.HeartbeatContextImpl;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.logging.LogProvider;

class LearnerContextImpl
extends AbstractContextImpl
implements LearnerContext {
    private long lastDeliveredInstanceId = -1L;
    private long lastLearnedInstanceId = -1L;
    private final CappedLogger learnMissLogger;
    private final HeartbeatContext heartbeatContext;
    private final AcceptorInstanceStore instanceStore;
    private final ObjectInputStreamFactory objectInputStreamFactory;
    private final ObjectOutputStreamFactory objectOutputStreamFactory;
    private final PaxosInstanceStore paxosInstances;

    LearnerContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, PaxosInstanceStore paxosInstances, AcceptorInstanceStore instanceStore, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.heartbeatContext = heartbeatContext;
        this.instanceStore = instanceStore;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.paxosInstances = paxosInstances;
        this.learnMissLogger = new CappedLogger(logging.getLog(LearnerState.class)).setDuplicateFilterEnabled(true);
    }

    private LearnerContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, long lastDeliveredInstanceId, long lastLearnedInstanceId, HeartbeatContext heartbeatContext, AcceptorInstanceStore instanceStore, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, PaxosInstanceStore paxosInstances) {
        super(me, commonState, logging, timeouts);
        this.lastDeliveredInstanceId = lastDeliveredInstanceId;
        this.lastLearnedInstanceId = lastLearnedInstanceId;
        this.heartbeatContext = heartbeatContext;
        this.instanceStore = instanceStore;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.paxosInstances = paxosInstances;
        this.learnMissLogger = new CappedLogger(logging.getLog(LearnerState.class)).setDuplicateFilterEnabled(true);
    }

    @Override
    public long getLastDeliveredInstanceId() {
        return this.lastDeliveredInstanceId;
    }

    @Override
    public void setLastDeliveredInstanceId(long lastDeliveredInstanceId) {
        this.lastDeliveredInstanceId = lastDeliveredInstanceId;
        this.instanceStore.lastDelivered(new org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId(lastDeliveredInstanceId));
    }

    @Override
    public long getLastLearnedInstanceId() {
        return this.lastLearnedInstanceId;
    }

    @Override
    public long getLastKnownLearnedInstanceInCluster() {
        return this.commonState.lastKnownLearnedInstanceInCluster();
    }

    @Override
    public void setLastKnownLearnedInstanceInCluster(long lastKnownLearnedInstanceInCluster, InstanceId instanceId) {
        this.commonState.setLastKnownLearnedInstanceInCluster(lastKnownLearnedInstanceInCluster, instanceId);
    }

    @Override
    public InstanceId getLastKnownAliveUpToDateInstance() {
        return this.commonState.getLastKnownAliveUpToDateInstance();
    }

    @Override
    public void learnedInstanceId(long instanceId) {
        this.lastLearnedInstanceId = Math.max(this.lastLearnedInstanceId, instanceId);
        if (this.lastLearnedInstanceId > this.commonState.lastKnownLearnedInstanceInCluster()) {
            this.commonState.setLastKnownLearnedInstanceInCluster(this.lastLearnedInstanceId, null);
        }
    }

    @Override
    public boolean hasDeliveredAllKnownInstances() {
        return this.lastDeliveredInstanceId == this.commonState.lastKnownLearnedInstanceInCluster();
    }

    @Override
    public void leave() {
        this.lastDeliveredInstanceId = -1L;
        this.lastLearnedInstanceId = -1L;
        this.commonState.setLastKnownLearnedInstanceInCluster(-1L, null);
    }

    @Override
    public PaxosInstance getPaxosInstance(org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId instanceId) {
        return this.paxosInstances.getPaxosInstance(instanceId);
    }

    @Override
    public AtomicBroadcastSerializer newSerializer() {
        return new AtomicBroadcastSerializer(this.objectInputStreamFactory, this.objectOutputStreamFactory);
    }

    @Override
    public Iterable<InstanceId> getAlive() {
        return this.heartbeatContext.getAlive();
    }

    @Override
    public void setNextInstanceId(long id) {
        this.commonState.setNextInstanceId(id);
    }

    @Override
    public void notifyLearnMiss(org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId instanceId) {
        this.learnMissLogger.warn("Did not have learned value for Paxos instance " + instanceId + ". This generally indicates that this instance has missed too many cluster events and is failing to catch up. If this error does not resolve soon it may become necessary to restart this cluster member so normal operation can resume.");
    }

    public LearnerContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, PaxosInstanceStore paxosInstancesSnapshot, AcceptorInstanceStore instanceStore, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, HeartbeatContextImpl snapshotHeartbeatContext) {
        return new LearnerContextImpl(this.me, commonStateSnapshot, logging, timeouts, this.lastDeliveredInstanceId, this.lastLearnedInstanceId, snapshotHeartbeatContext, instanceStore, objectInputStreamFactory, objectOutputStreamFactory, paxosInstancesSnapshot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearnerContextImpl that = (LearnerContextImpl)o;
        if (this.lastDeliveredInstanceId != that.lastDeliveredInstanceId) {
            return false;
        }
        if (this.lastLearnedInstanceId != that.lastLearnedInstanceId) {
            return false;
        }
        if (this.heartbeatContext != null ? !this.heartbeatContext.equals(that.heartbeatContext) : that.heartbeatContext != null) {
            return false;
        }
        if (this.instanceStore != null ? !this.instanceStore.equals(that.instanceStore) : that.instanceStore != null) {
            return false;
        }
        return this.paxosInstances != null ? this.paxosInstances.equals(that.paxosInstances) : that.paxosInstances == null;
    }

    public int hashCode() {
        int result = (int)(this.lastDeliveredInstanceId ^ this.lastDeliveredInstanceId >>> 32);
        result = 31 * result + (int)(this.lastLearnedInstanceId ^ this.lastLearnedInstanceId >>> 32);
        result = 31 * result + (this.heartbeatContext != null ? this.heartbeatContext.hashCode() : 0);
        result = 31 * result + (this.instanceStore != null ? this.instanceStore.hashCode() : 0);
        result = 31 * result + (this.paxosInstances != null ? this.paxosInstances.hashCode() : 0);
        return result;
    }
}

