/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.Connection;
import org.neo4j.com.PortRangeSocketBinder;
import org.neo4j.helpers.HostnamePort;

public class PortRangeSocketBinderTest {
    @Test
    public void shouldReThrowExceptionIfCannotBindToPort() {
        HostnamePort localhost = new HostnamePort("localhost", 9000);
        ServerBootstrap bootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9000))).thenThrow(new Throwable[]{new ChannelException()});
        try {
            new PortRangeSocketBinder(bootstrap).bindToFirstAvailablePortInRange(localhost);
            Assert.fail((String)"should have thrown ChannelException");
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReThrowExceptionIfCannotBindToAnyOfThePortsInTheRange() {
        HostnamePort localhost = new HostnamePort("localhost", 9000, 9002);
        ServerBootstrap bootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9000))).thenThrow(new Throwable[]{new ChannelException("Failed to bind to: 9000")});
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9001))).thenThrow(new Throwable[]{new ChannelException("Failed to bind to: 9001")});
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9002))).thenThrow(new Throwable[]{new ChannelException("Failed to bind to: 9002")});
        try {
            new PortRangeSocketBinder(bootstrap).bindToFirstAvailablePortInRange(localhost);
            Assert.fail((String)"should have thrown ChannelException");
        }
        catch (ChannelException ex) {
            Assert.assertEquals((long)2L, (long)this.suppressedExceptions(ex));
        }
    }

    private int suppressedExceptions(Throwable throwable) {
        int suppressed = 0;
        for (Throwable ignored : throwable.getSuppressed()) {
            ++suppressed;
            suppressed += this.suppressedExceptions(ignored);
        }
        return suppressed;
    }

    @Test
    public void shouldReturnChannelAndSocketIfPortIsFree() {
        HostnamePort localhost = new HostnamePort("localhost", 9000);
        ServerBootstrap bootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9000))).thenReturn((Object)channel);
        Connection connection = new PortRangeSocketBinder(bootstrap).bindToFirstAvailablePortInRange(localhost);
        Assert.assertEquals((Object)channel, (Object)connection.getChannel());
        Assert.assertEquals((Object)new InetSocketAddress("localhost", 9000), (Object)connection.getSocketAddress());
    }

    @Test
    public void shouldReturnChannelAndSocketIfAnyPortsAreFree() {
        HostnamePort localhost = new HostnamePort("localhost", 9000, 9001);
        ServerBootstrap bootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9000))).thenThrow(new Throwable[]{new ChannelException()});
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9001))).thenReturn((Object)channel);
        Connection connection = new PortRangeSocketBinder(bootstrap).bindToFirstAvailablePortInRange(localhost);
        Assert.assertEquals((Object)channel, (Object)connection.getChannel());
        Assert.assertEquals((Object)new InetSocketAddress(localhost.getHost(), 9001), (Object)connection.getSocketAddress());
    }

    @Test
    public void shouldReturnChannelAndSocketIfPortRangeIsInverted() {
        HostnamePort localhost = new HostnamePort("localhost", 9001, 9000);
        ServerBootstrap bootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", 9001))).thenReturn((Object)channel);
        Connection connection = new PortRangeSocketBinder(bootstrap).bindToFirstAvailablePortInRange(localhost);
        Assert.assertEquals((Object)channel, (Object)connection.getChannel());
        Assert.assertEquals((Object)new InetSocketAddress(localhost.getHost(), 9001), (Object)connection.getSocketAddress());
    }
}

