/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.neo4j.com.ComException;

public class ChunkingChannelBuffer
implements ChannelBuffer,
ChannelFutureListener {
    static final byte CONTINUATION_LAST = 0;
    static final byte CONTINUATION_MORE = 1;
    static final byte OUTCOME_SUCCESS = 0;
    static final byte OUTCOME_FAILURE = 1;
    protected static final int MAX_WRITE_AHEAD_CHUNKS = 5;
    private ChannelBuffer buffer;
    private final Channel channel;
    private final int capacity;
    private int continuationPosition;
    private final AtomicInteger writeAheadCounter = new AtomicInteger();
    private volatile boolean failure;
    private final byte applicationProtocolVersion;
    private final byte internalProtocolVersion;

    public ChunkingChannelBuffer(ChannelBuffer buffer, Channel channel, int capacity, byte internalProtocolVersion, byte applicationProtocolVersion) {
        this.buffer = buffer;
        this.channel = channel;
        this.capacity = capacity;
        this.internalProtocolVersion = internalProtocolVersion;
        this.applicationProtocolVersion = applicationProtocolVersion;
        this.addRoomForContinuationHeader();
    }

    private void addRoomForContinuationHeader() {
        this.continuationPosition = this.writerIndex();
        this.buffer.writeBytes(this.header((byte)0));
    }

    private byte[] header(byte continuation) {
        byte[] header = new byte[]{(byte)(this.internalProtocolVersion << 2 | (this.failure ? 1 : 0) << 1 | continuation), this.applicationProtocolVersion};
        return header;
    }

    private void setContinuation(byte continuation) {
        this.buffer.setBytes(this.continuationPosition, this.header(continuation));
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public boolean readable() {
        return this.buffer.readable();
    }

    public boolean writable() {
        return this.buffer.writable();
    }

    public void clear(boolean failure) {
        this.buffer.clear();
        this.failure = failure;
        this.addRoomForContinuationHeader();
    }

    public void clear() {
        this.clear(false);
    }

    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    public void discardReadBytes() {
        this.buffer.discardReadBytes();
    }

    public void ensureWritableBytes(int writableBytes) {
        this.buffer.ensureWritableBytes(writableBytes);
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    public int getMedium(int index) {
        return this.buffer.getMedium(index);
    }

    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public void getBytes(int index, ChannelBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, ChannelBuffer dst, int length) {
        this.buffer.getBytes(index, dst, length);
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index, out, length);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index, out, length);
    }

    public void setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    public void setShort(int index, int value) {
        this.buffer.setShort(index, value);
    }

    public void setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
    }

    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    public void setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    public void setChar(int index, int value) {
        this.buffer.setChar(index, value);
    }

    public void setFloat(int index, float value) {
        this.buffer.setFloat(index, value);
    }

    public void setDouble(int index, double value) {
        this.buffer.setDouble(index, value);
    }

    public void setBytes(int index, ChannelBuffer src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, ChannelBuffer src, int length) {
        this.buffer.setBytes(index, src, length);
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    public void setZero(int index, int length) {
        this.buffer.setZero(index, length);
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public ChannelBuffer readBytes(int length) {
        return this.buffer.readBytes(length);
    }

    public ChannelBuffer readBytes(ChannelBufferIndexFinder indexFinder) {
        return this.buffer.readBytes(indexFinder);
    }

    public ChannelBuffer readSlice(int length) {
        return this.buffer.readSlice(length);
    }

    public ChannelBuffer readSlice(ChannelBufferIndexFinder indexFinder) {
        return this.buffer.readSlice(indexFinder);
    }

    public void readBytes(ChannelBuffer dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(ChannelBuffer dst, int length) {
        this.buffer.readBytes(dst, length);
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.buffer.readBytes(out, length);
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.buffer.readBytes(out, length);
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public int skipBytes(ChannelBufferIndexFinder indexFinder) {
        return this.buffer.skipBytes(indexFinder);
    }

    private void sendChunkIfNeeded(int bytesPlus) {
        if (this.writerIndex() + bytesPlus >= this.capacity) {
            this.setContinuation((byte)1);
            this.writeCurrentChunk();
            this.buffer = this.newChannelBuffer();
            this.addRoomForContinuationHeader();
        }
    }

    protected ChannelBuffer newChannelBuffer() {
        return ChannelBuffers.dynamicBuffer((int)this.capacity);
    }

    private void writeCurrentChunk() {
        if (!(this.channel.isOpen() && this.channel.isConnected() && this.channel.isBound())) {
            throw new ComException("Channel has been closed, so no need to try to write to it anymore. Client closed it?");
        }
        this.waitForClientToCatchUpOnReadingChunks();
        ChannelFuture future = this.channel.write((Object)this.buffer);
        future.addListener(this.newChannelFutureListener(this.buffer));
        this.writeAheadCounter.incrementAndGet();
    }

    protected ChannelFutureListener newChannelFutureListener(ChannelBuffer buffer) {
        return this;
    }

    private void waitForClientToCatchUpOnReadingChunks() {
        boolean waited = false;
        while (this.channel.isConnected() && this.writeAheadCounter.get() >= 5) {
            waited = true;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (!(!waited || this.channel.isConnected() && this.channel.isOpen())) {
            throw new ComException("Channel has been closed");
        }
    }

    public void operationComplete(ChannelFuture future) {
        if (!future.isDone()) {
            throw new ComException("This should not be possible because we waited for the future to be done");
        }
        if (!future.isSuccess() || future.isCancelled()) {
            future.getChannel().close();
        }
        this.writeAheadCounter.decrementAndGet();
    }

    public void done() {
        if (this.readable()) {
            this.writeCurrentChunk();
        }
    }

    public void writeByte(int value) {
        this.sendChunkIfNeeded(1);
        this.buffer.writeByte(value);
    }

    public void writeShort(int value) {
        this.sendChunkIfNeeded(2);
        this.buffer.writeShort(value);
    }

    public void writeMedium(int value) {
        this.sendChunkIfNeeded(4);
        this.buffer.writeMedium(value);
    }

    public void writeInt(int value) {
        this.sendChunkIfNeeded(4);
        this.buffer.writeInt(value);
    }

    public void writeLong(long value) {
        this.sendChunkIfNeeded(8);
        this.buffer.writeLong(value);
    }

    public void writeChar(int value) {
        this.sendChunkIfNeeded(2);
        this.buffer.writeChar(value);
    }

    public void writeFloat(float value) {
        this.sendChunkIfNeeded(8);
        this.buffer.writeFloat(value);
    }

    public void writeDouble(double value) {
        this.sendChunkIfNeeded(8);
        this.buffer.writeDouble(value);
    }

    public void writeBytes(ChannelBuffer src) {
        this.sendChunkIfNeeded(src.capacity());
        this.buffer.writeBytes(src);
    }

    public void writeBytes(ChannelBuffer src, int length) {
        this.sendChunkIfNeeded(length);
        this.buffer.writeBytes(src, length);
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        this.sendChunkIfNeeded(length);
        this.buffer.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(byte[] src) {
        this.sendChunkIfNeeded(src.length);
        this.buffer.writeBytes(src);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.sendChunkIfNeeded(length);
        this.buffer.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ByteBuffer src) {
        this.sendChunkIfNeeded(src.limit());
        this.buffer.writeBytes(src);
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        this.sendChunkIfNeeded(length);
        return this.buffer.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.sendChunkIfNeeded(length);
        return this.buffer.writeBytes(in, length);
    }

    public void writeZero(int length) {
        this.sendChunkIfNeeded(length);
        this.buffer.writeZero(length);
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buffer.indexOf(fromIndex, toIndex, value);
    }

    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        return this.buffer.indexOf(fromIndex, toIndex, indexFinder);
    }

    public int bytesBefore(byte value) {
        return this.buffer.bytesBefore(value);
    }

    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        return this.buffer.bytesBefore(indexFinder);
    }

    public int bytesBefore(int length, byte value) {
        return this.buffer.bytesBefore(length, value);
    }

    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        return this.buffer.bytesBefore(length, indexFinder);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.buffer.bytesBefore(index, length, value);
    }

    public int bytesBefore(int index, int length, ChannelBufferIndexFinder indexFinder) {
        return this.buffer.bytesBefore(index, length, indexFinder);
    }

    public ChannelBuffer copy() {
        return this.buffer.copy();
    }

    public ChannelBuffer copy(int index, int length) {
        return this.buffer.copy(index, length);
    }

    public ChannelBuffer slice() {
        return this.buffer.slice();
    }

    public ChannelBuffer slice(int index, int length) {
        return this.buffer.slice(index, length);
    }

    public ChannelBuffer duplicate() {
        return this.buffer.duplicate();
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer.toByteBuffer();
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }

    public ByteBuffer[] toByteBuffers() {
        return this.buffer.toByteBuffers();
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        return this.buffer.toByteBuffers(index, length);
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public String toString(Charset charset) {
        return this.buffer.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.buffer.toString(index, length, charset);
    }

    public String toString(String charsetName) {
        return this.buffer.toString(charsetName);
    }

    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.buffer.toString(charsetName, terminatorFinder);
    }

    public String toString(int index, int length, String charsetName) {
        return this.buffer.toString(index, length, charsetName);
    }

    public String toString(int index, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.buffer.toString(index, length, charsetName, terminatorFinder);
    }

    public int compareTo(ChannelBuffer buffer) {
        return this.buffer.compareTo(buffer);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

