/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.Numbers;

public class NumbersTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void failSafeCastLongToInt() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 2147483648 is too big to be represented as int");
        Numbers.safeCastLongToInt((long)0x80000000L);
    }

    @Test
    public void failSafeCastLongToShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 32768 is too big to be represented as short");
        Numbers.safeCastLongToShort((long)32768L);
    }

    @Test
    public void failSafeCastIntToUnsignedShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 131068 is too big to be represented as unsigned short");
        Numbers.safeCastIntToUnsignedShort((int)131068);
    }

    @Test
    public void failSafeCastLongToByte() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 128 is too big to be represented as byte");
        Numbers.safeCastLongToByte((long)128L);
    }

    @Test
    public void failSafeCastIntToShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 32768 is too big to be represented as short");
        Numbers.safeCastIntToShort((int)32768);
    }

    @Test
    public void castLongToInt() {
        Assert.assertEquals((long)1L, (long)Numbers.safeCastLongToInt((long)1L));
        Assert.assertEquals((long)10L, (long)Numbers.safeCastLongToInt((long)10L));
        Assert.assertEquals((long)-1L, (long)Numbers.safeCastLongToInt((long)-1L));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Numbers.safeCastLongToInt((long)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)Numbers.safeCastLongToInt((long)Integer.MIN_VALUE));
    }

    @Test
    public void castLongToShort() {
        Assert.assertEquals((long)1L, (long)Numbers.safeCastLongToShort((long)1L));
        Assert.assertEquals((long)10L, (long)Numbers.safeCastLongToShort((long)10L));
        Assert.assertEquals((long)-1L, (long)Numbers.safeCastLongToShort((long)-1L));
        Assert.assertEquals((long)32767L, (long)Numbers.safeCastLongToShort((long)32767L));
        Assert.assertEquals((long)-32768L, (long)Numbers.safeCastLongToShort((long)-32768L));
    }

    @Test
    public void castIntToUnsighedShort() {
        Assert.assertEquals((long)1L, (long)Numbers.safeCastIntToUnsignedShort((int)1));
        Assert.assertEquals((long)10L, (long)Numbers.safeCastIntToUnsignedShort((int)10));
        Assert.assertEquals((long)-1L, (long)Numbers.safeCastIntToUnsignedShort((int)65535));
    }

    @Test
    public void castIntToShort() {
        Assert.assertEquals((long)1L, (long)Numbers.safeCastIntToShort((int)1));
        Assert.assertEquals((long)10L, (long)Numbers.safeCastIntToShort((int)10));
        Assert.assertEquals((long)32767L, (long)Numbers.safeCastIntToShort((int)Short.MAX_VALUE));
        Assert.assertEquals((long)-32768L, (long)Numbers.safeCastIntToShort((int)Short.MIN_VALUE));
    }

    @Test
    public void castLongToByte() {
        Assert.assertEquals((long)1L, (long)Numbers.safeCastLongToByte((long)1L));
        Assert.assertEquals((long)10L, (long)Numbers.safeCastLongToByte((long)10L));
        Assert.assertEquals((long)-1L, (long)Numbers.safeCastLongToByte((long)-1L));
        Assert.assertEquals((long)127L, (long)Numbers.safeCastLongToByte((long)127L));
        Assert.assertEquals((long)-128L, (long)Numbers.safeCastLongToByte((long)-128L));
    }

    @Test
    public void castUnsignedShortToInt() {
        Assert.assertEquals((long)1L, (long)Numbers.unsignedShortToInt((short)1));
        Assert.assertEquals((long)32767L, (long)Numbers.unsignedShortToInt((short)Short.MAX_VALUE));
        Assert.assertEquals((long)65535L, (long)Numbers.unsignedShortToInt((short)-1));
    }
}

