/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class TestLifecycleException {
    @Test
    public void shouldMakeNoneToStoppedIntoHumanReadableInitMessage() {
        Assert.assertThat((Object)this.exceptionFor(LifecycleStatus.NONE, LifecycleStatus.STOPPED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to initialize."));
    }

    @Test
    public void shouldMakeStoppedToStartedIntoHumanReadableStartingMessage() {
        Assert.assertThat((Object)this.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.STARTED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' was successfully initialized, but failed to start."));
    }

    @Test
    public void shouldMakeStartedToStoppedIntoHumanReadableStoppingMessage() {
        Assert.assertThat((Object)this.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to stop."));
    }

    @Test
    public void shouldMakeShutdownIntoHumanReadableShutdownMessage() {
        Assert.assertThat((Object)this.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to shut down."));
    }

    @Test
    public void shouldIncludeRootCauseMessageInExceptionMessage() {
        Exception root = new Exception("big bad root cause");
        Exception intermediate = new Exception("intermediate exception", root);
        Assert.assertThat((Object)this.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED, intermediate).getMessage(), (Matcher)Matchers.containsString((String)root.getMessage()));
    }

    private LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to) {
        return this.exceptionFor(from, to, null);
    }

    private LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to, Throwable cause) {
        return new LifecycleException(new Object(){

            public String toString() {
                return "SomeComponent";
            }
        }, from, to, cause);
    }
}

