/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;

public class LocalMemoryTrackerTest {
    @Test
    public void trackMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocated(10L);
        memoryTracker.allocated(20L);
        memoryTracker.allocated(40L);
        Assert.assertEquals((long)70L, (long)memoryTracker.usedDirectMemory());
    }

    @Test
    public void trackMemoryDeallocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocated(100L);
        Assert.assertEquals((long)100L, (long)memoryTracker.usedDirectMemory());
        memoryTracker.deallocated(20L);
        Assert.assertEquals((long)80L, (long)memoryTracker.usedDirectMemory());
        memoryTracker.deallocated(40L);
        Assert.assertEquals((long)40L, (long)memoryTracker.usedDirectMemory());
    }

    @Test
    public void localMemoryTrackerPropagatesAllocationsToGlobalTracker() {
        GlobalMemoryTracker globalMemoryTracker = GlobalMemoryTracker.INSTANCE;
        long initialGlobalUsage = globalMemoryTracker.usedDirectMemory();
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocated(100L);
        Assert.assertEquals((long)100L, (long)memoryTracker.usedDirectMemory());
        Assert.assertEquals((long)100L, (long)(globalMemoryTracker.usedDirectMemory() - initialGlobalUsage));
        memoryTracker.deallocated(50L);
        Assert.assertEquals((long)50L, (long)memoryTracker.usedDirectMemory());
        Assert.assertEquals((long)50L, (long)(globalMemoryTracker.usedDirectMemory() - initialGlobalUsage));
    }
}

