/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;

public class Race {
    private static final int UNLIMITED = 0;
    private final List<Contestant> contestants = new ArrayList<Contestant>();
    private volatile CountDownLatch readySet;
    private final CountDownLatch go = new CountDownLatch(1);
    private volatile boolean addSomeMinorRandomStartDelays;
    private volatile BooleanSupplier endCondition;
    private volatile boolean failure;
    private boolean asyncExecution;

    public Race withRandomStartDelays() {
        this.addSomeMinorRandomStartDelays = true;
        return this;
    }

    public Race withEndCondition(BooleanSupplier ... endConditions) {
        for (BooleanSupplier endCondition : endConditions) {
            this.endCondition = this.mergeEndCondition(endCondition);
        }
        return this;
    }

    public Race withMaxDuration(long time, TimeUnit unit) {
        long endTime = System.currentTimeMillis() + unit.toMillis(time);
        this.endCondition = this.mergeEndCondition(() -> System.currentTimeMillis() >= endTime);
        return this;
    }

    private BooleanSupplier mergeEndCondition(BooleanSupplier additionalEndCondition) {
        BooleanSupplier existingEndCondition = this.endCondition;
        return existingEndCondition == null ? additionalEndCondition : () -> existingEndCondition.getAsBoolean() || additionalEndCondition.getAsBoolean();
    }

    public static Runnable throwing(ThrowingRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void addContestants(int count, Runnable contestant) {
        this.addContestants(count, contestant, 0);
    }

    public void addContestants(int count, Runnable contestant, int maxNumberOfRuns) {
        for (int i = 0; i < count; ++i) {
            this.addContestant(contestant, maxNumberOfRuns);
        }
    }

    public void addContestant(Runnable contestant) {
        this.addContestant(contestant, 0);
    }

    public void addContestant(Runnable contestant, int maxNumberOfRuns) {
        this.contestants.add(new Contestant(contestant, this.contestants.size(), maxNumberOfRuns));
    }

    public void goAsync() throws Throwable {
        this.asyncExecution = true;
        this.go(0L, TimeUnit.MILLISECONDS);
    }

    public void go() throws Throwable {
        this.go(0L, TimeUnit.MILLISECONDS);
    }

    public void go(long maxWaitTime, TimeUnit unit) throws Throwable {
        if (this.endCondition == null) {
            this.endCondition = () -> true;
        }
        this.readySet = new CountDownLatch(this.contestants.size());
        for (Contestant contestant : this.contestants) {
            contestant.start();
        }
        this.readySet.await();
        this.go.countDown();
        if (this.asyncExecution) {
            return;
        }
        int errorCount = 0;
        long maxWaitTimeMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long waitedSoFar = 0L;
        for (Contestant contestant : this.contestants) {
            if (maxWaitTime == 0L) {
                contestant.join();
            } else {
                long time = System.currentTimeMillis();
                contestant.join(maxWaitTimeMillis - waitedSoFar);
                if ((waitedSoFar += System.currentTimeMillis() - time) >= maxWaitTimeMillis) {
                    throw new TimeoutException("Didn't complete after " + maxWaitTime + " " + (Object)((Object)unit));
                }
            }
            if (contestant.error == null) continue;
            ++errorCount;
        }
        if (errorCount > 1) {
            Throwable errors = new Throwable("Multiple errors found");
            for (Contestant contestant : this.contestants) {
                if (contestant.error == null) continue;
                errors.addSuppressed(contestant.error);
            }
            throw errors;
        }
        if (errorCount == 1) {
            for (Contestant contestant : this.contestants) {
                if (contestant.error == null) continue;
                throw contestant.error;
            }
        }
    }

    private class Contestant
    extends Thread {
        private volatile Throwable error;
        private final int maxNumberOfRuns;
        private int runs;

        Contestant(Runnable code, int nr, int maxNumberOfRuns) {
            super(code, "Contestant#" + nr);
            this.maxNumberOfRuns = maxNumberOfRuns;
            this.setUncaughtExceptionHandler((thread, error) -> {});
        }

        @Override
        public void run() {
            Race.this.readySet.countDown();
            try {
                Race.this.go.await();
            }
            catch (InterruptedException e) {
                this.error = e;
                this.interrupt();
                return;
            }
            if (Race.this.addSomeMinorRandomStartDelays) {
                this.randomlyDelaySlightly();
            }
            try {
                while (!Race.this.failure) {
                    super.run();
                    if ((this.maxNumberOfRuns == 0 || ++this.runs != this.maxNumberOfRuns) && !Race.this.endCondition.getAsBoolean()) continue;
                    break;
                }
            }
            catch (Throwable e) {
                this.error = e;
                Race.this.failure = true;
                throw e;
            }
        }

        private void randomlyDelaySlightly() {
            int millis = ThreadLocalRandom.current().nextInt(100);
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10 + millis));
        }
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

