/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

public class Randoms {
    public static final Configuration DEFAULT = new Default();
    public static final int CS_LOWERCASE_LETTERS = 1;
    public static final int CS_UPPERCASE_LETTERS = 2;
    public static final int CS_DIGITS = 3;
    public static final int CS_SYMBOLS = 4;
    public static final int CSA_LETTERS = 3;
    public static final int CSA_LETTERS_AND_DIGITS = 3;
    public static final long NANOS_PER_SECOND = 1000000000L;
    private final Random random;
    private final Configuration configuration;

    public Randoms() {
        this(ThreadLocalRandom.current(), DEFAULT);
    }

    public Randoms(Random random, Configuration configuration) {
        this.random = random;
        this.configuration = configuration;
    }

    public Randoms fork(Configuration configuration) {
        return new Randoms(this.random, configuration);
    }

    public Random random() {
        return this.random;
    }

    public int intBetween(int min, int max) {
        return min + this.random.nextInt(max - min + 1);
    }

    public String string() {
        return this.string(this.configuration.stringMinLength(), this.configuration.stringMaxLength(), this.configuration.stringCharacterSets());
    }

    public String string(int minLength, int maxLength, int characterSets) {
        char[] chars = new char[this.intBetween(minLength, maxLength)];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.character(characterSets);
        }
        return String.valueOf(chars);
    }

    public Object array() {
        int length = this.intBetween(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
        byte componentType = this.propertyType(false);
        Object itemType = this.propertyValue(componentType);
        Object array = Array.newInstance(itemType.getClass(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.propertyValue(componentType));
        }
        return array;
    }

    public char character(int characterSets) {
        int bit;
        int setCount = Integer.bitCount(characterSets);
        while ((characterSets & (bit = 1 << this.random.nextInt(setCount))) == 0) {
        }
        switch (bit) {
            case 1: {
                return (char)this.intBetween(97, 122);
            }
            case 2: {
                return (char)this.intBetween(65, 90);
            }
            case 3: {
                return (char)this.intBetween(48, 57);
            }
            case 4: {
                return this.symbol();
            }
        }
        throw new IllegalArgumentException("Unknown character set " + bit);
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        assert (min <= max);
        int diff = min == max ? 0 : this.random.nextInt(max - min);
        int length = min + diff;
        Object[] result = (Object[])Array.newInstance(among.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            T candidate;
            do {
                candidate = this.among(among);
            } while (!allowDuplicates && Randoms.contains(result, candidate));
            result[i] = candidate;
        }
        return result;
    }

    private static <T> boolean contains(T[] array, T contains) {
        for (T item : array) {
            if (!Randoms.nullSafeEquals(item, contains)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean nullSafeEquals(T first, T other) {
        return first == null ? other == null : first.equals(other);
    }

    public <T> T among(T[] among) {
        return among[this.random.nextInt(among.length)];
    }

    public <T> T among(List<T> among) {
        return among.get(this.random.nextInt(among.size()));
    }

    public <T> void among(List<T> among, Consumer<T> action) {
        if (!among.isEmpty()) {
            T item = this.among(among);
            action.accept(item);
        }
    }

    public Number numberPropertyValue() {
        int type = this.random.nextInt(6);
        switch (type) {
            case 0: {
                return (byte)this.random.nextInt();
            }
            case 1: {
                return (short)this.random.nextInt();
            }
            case 2: {
                return this.random.nextInt();
            }
            case 3: {
                return this.random.nextLong();
            }
            case 4: {
                return Float.valueOf(this.random.nextFloat());
            }
            case 5: {
                return this.random.nextDouble();
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    public Object propertyValue() {
        return this.propertyValue(this.propertyType(true));
    }

    private byte propertyType(boolean allowArrays) {
        return (byte)this.random.nextInt(allowArrays ? 17 : 16);
    }

    private Object propertyValue(byte type) {
        switch (type) {
            case 0: {
                return this.random.nextBoolean();
            }
            case 1: {
                return (byte)this.random.nextInt();
            }
            case 2: {
                return (short)this.random.nextInt();
            }
            case 3: {
                return Character.valueOf(this.character(3));
            }
            case 4: {
                return this.random.nextInt();
            }
            case 5: {
                return this.random.nextLong();
            }
            case 6: {
                return Float.valueOf(this.random.nextFloat());
            }
            case 7: {
                return this.random.nextDouble();
            }
            case 8: {
                return this.randomDateTime();
            }
            case 9: {
                return this.randomTime();
            }
            case 10: {
                return this.randomDate();
            }
            case 11: {
                return this.randomLocalDateTime();
            }
            case 12: {
                return this.randomLocalTime();
            }
            case 13: {
                return this.randomPeriod();
            }
            case 14: {
                return this.randomDuration();
            }
            case 15: {
                return this.string();
            }
            case 16: {
                return this.array();
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    public OffsetTime randomTime() {
        return OffsetTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
    }

    public LocalDateTime randomLocalDateTime() {
        return LocalDateTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
    }

    public LocalDate randomDate() {
        return LocalDate.ofEpochDay(this.nextLong(LocalDate.MIN.toEpochDay(), LocalDate.MAX.toEpochDay()));
    }

    public LocalTime randomLocalTime() {
        return LocalTime.ofNanoOfDay(this.nextLong(LocalTime.MIN.toNanoOfDay(), LocalTime.MAX.toNanoOfDay()));
    }

    private Instant randomInstant() {
        return Instant.ofEpochSecond(this.nextLong(LocalDateTime.MIN.toEpochSecond(ZoneOffset.UTC), LocalDateTime.MAX.toEpochSecond(ZoneOffset.UTC)), this.nextLong(1000000000L));
    }

    public ZonedDateTime randomDateTime() {
        return ZonedDateTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
    }

    public TemporalAmount randomPeriod() {
        return Period.of(this.random.nextInt(), this.random.nextInt(12), this.random.nextInt(28));
    }

    public TemporalAmount randomDuration() {
        return Duration.of(this.nextLong(ChronoUnit.DAYS.getDuration().getSeconds()), ChronoUnit.SECONDS);
    }

    private char symbol() {
        int range = this.random.nextInt(5);
        switch (range) {
            case 0: {
                return (char)this.intBetween(33, 47);
            }
            case 1: {
                return (char)this.intBetween(58, 64);
            }
            case 2: {
                return (char)this.intBetween(91, 96);
            }
            case 3: {
                return (char)this.intBetween(123, 126);
            }
            case 4: {
                return ' ';
            }
        }
        throw new IllegalArgumentException("Unknown symbol range " + range);
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long bound) {
        return Math.abs(this.random.nextLong()) % bound;
    }

    public long nextLong(long origin, long bound) {
        return this.nextLong(bound - origin + 1L) + origin;
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public int nextInt(int bound) {
        return this.random.nextInt(bound);
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public void nextBytes(byte[] data) {
        this.random.nextBytes(data);
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public static class Default
    implements Configuration {
        @Override
        public int stringMinLength() {
            return 5;
        }

        @Override
        public int stringMaxLength() {
            return 20;
        }

        @Override
        public int stringCharacterSets() {
            return 3;
        }

        @Override
        public int arrayMinLength() {
            return 1;
        }

        @Override
        public int arrayMaxLength() {
            return 10;
        }
    }

    public static interface Configuration {
        public int stringMinLength();

        public int stringMaxLength();

        public int stringCharacterSets();

        public int arrayMinLength();

        public int arrayMaxLength();
    }
}

