/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.phases;

import org.neo4j.cypher.internal.frontend.v3_4.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.UnresolvedCall;
import org.neo4j.cypher.internal.frontend.v3_4.notification.DeprecatedFieldNotification;
import org.neo4j.cypher.internal.frontend.v3_4.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_4.notification.ProcedureWarningNotification;
import org.neo4j.cypher.internal.frontend.v3_4.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_4.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_4.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_4.phases.Condition;
import org.neo4j.cypher.internal.frontend.v3_4.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_4.phases.Phase;
import org.neo4j.cypher.internal.frontend.v3_4.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_4.phases.VisitorPhase;
import org.neo4j.cypher.internal.util.v3_4.Foldable;
import org.neo4j.cypher.internal.util.v3_4.Foldable$;
import org.neo4j.cypher.internal.util.v3_4.InternalException;
import org.neo4j.cypher.internal.util.v3_4.InternalException$;
import org.neo4j.cypher.internal.v3_4.logical.plans.FieldSignature;
import org.neo4j.cypher.internal.v3_4.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.v3_4.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.v3_4.logical.plans.ResolvedCall;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.runtime.ObjectRef;

public final class ProcedureWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static final ProcedureWarnings$ MODULE$;

    static {
        new ProcedureWarnings$();
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.class.process((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.class.postConditions((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.class.transform((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.class.name((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.class.andThen((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.class.adds((Transformer)this, (Condition)condition);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findWarnings(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1)new Serializable(internalNotificationLogger){
            public static final long serialVersionUID = 0L;
            private final InternalNotificationLogger eta$0$2$1;

            public final void apply(InternalNotification notification) {
                this.eta$0$2$1.log(notification);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
    }

    private Set<InternalNotification> findWarnings(Statement statement) {
        return (Set)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                void var11_14;
                boolean bl = false;
                ObjectRef objectRef = ObjectRef.create(null);
                A1 A1 = x2;
                if (A1 instanceof ResolvedCall) {
                    bl = true;
                    objectRef.elem = (ResolvedCall)A1;
                    ProcedureSignature procedureSignature = ((ResolvedCall)objectRef.elem).signature();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.warning();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String warning = (String)some.x();
                            Serializable serializable = new Serializable(this, name, warning, objectRef){
                                public static final long serialVersionUID = 0L;
                                private final QualifiedName name$2;
                                private final String warning$1;
                                private final ObjectRef x2$2;

                                public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                    return new Tuple2((Object)seq.$plus((Object)new ProcedureWarningNotification(((ResolvedCall)this.x2$2.elem).position(), this.name$2.toString(), this.warning$1)), (Object)None$.MODULE$);
                                }
                                {
                                    this.name$2 = name$2;
                                    this.warning$1 = warning$1;
                                    this.x2$2 = x2$2;
                                }
                            };
                            return var11_14;
                        }
                    }
                }
                if (bl) {
                    ProcedureSignature procedureSignature = ((ResolvedCall)objectRef.elem).signature();
                    IndexedSeq results = ((ResolvedCall)objectRef.elem).callResults();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.outputSignature();
                        Option option2 = procedureSignature.deprecationInfo();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            IndexedSeq output = (IndexedSeq)some.x();
                            if (None$.MODULE$.equals(option2) && output.exists((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(FieldSignature x$1) {
                                    return x$1.deprecated();
                                }
                            })) {
                                Serializable serializable = new Serializable(this, name, output, results){
                                    public static final long serialVersionUID = 0L;
                                    private final QualifiedName name$3;
                                    private final IndexedSeq output$1;
                                    private final IndexedSeq results$1;

                                    public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> set) {
                                        return new Tuple2((Object)set.$plus$plus(ProcedureWarnings$.MODULE$.org$neo4j$cypher$internal$compiler$v3_4$phases$ProcedureWarnings$$usedDeprecatedFields(this.name$3.toString(), (Seq<ProcedureResultItem>)this.results$1, (Seq<FieldSignature>)this.output$1)), (Object)None$.MODULE$);
                                    }
                                    {
                                        this.name$3 = name$3;
                                        this.output$1 = output$1;
                                        this.results$1 = results$1;
                                    }
                                };
                                return var11_14;
                            }
                        }
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already", InternalException$.MODULE$.$lessinit$greater$default$2());
                }
                Object object = function1.apply(x2);
                return var11_14;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x2) {
                ProcedureSignature procedureSignature;
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                Object object = x2;
                if (object instanceof ResolvedCall) {
                    Option option;
                    bl = true;
                    resolvedCall = (ResolvedCall)object;
                    ProcedureSignature procedureSignature2 = resolvedCall.signature();
                    if (procedureSignature2 != null && (option = procedureSignature2.warning()) instanceof Some) {
                        return true;
                    }
                }
                if (bl && (procedureSignature = resolvedCall.signature()) != null) {
                    Option option = procedureSignature.outputSignature();
                    Option option2 = procedureSignature.deprecationInfo();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        IndexedSeq output = (IndexedSeq)some.x();
                        if (None$.MODULE$.equals(option2) && output.exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(FieldSignature x$1) {
                                return x$1.deprecated();
                            }
                        })) {
                            return true;
                        }
                    }
                }
                if (!(object instanceof UnresolvedCall)) return false;
                return true;
            }
        });
    }

    public Seq<DeprecatedFieldNotification> org$neo4j$cypher$internal$compiler$v3_4$phases$ProcedureWarnings$$usedDeprecatedFields(String procedure, Seq<ProcedureResultItem> used, Seq<FieldSignature> available) {
        return (Seq)((TraversableLike)used.filter((Function1)new Serializable(available){
            public static final long serialVersionUID = 0L;
            private final Seq available$1;

            public final boolean apply(ProcedureResultItem r) {
                return this.available$1.exists((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final ProcedureResultItem r$1;

                    public final boolean apply(FieldSignature o) {
                        String string = o.name();
                        String string2 = this.r$1.outputName();
                        return !(string != null ? !string.equals(string2) : string2 != null) && o.deprecated();
                    }
                    {
                        this.r$1 = r$1;
                    }
                });
            }
            {
                this.available$1 = available$1;
            }
        })).map((Function1)new Serializable(procedure){
            public static final long serialVersionUID = 0L;
            private final String procedure$1;

            public final DeprecatedFieldNotification apply(ProcedureResultItem r) {
                return new DeprecatedFieldNotification(r.position(), this.procedure$1, r.outputName());
            }
            {
                this.procedure$1 = procedure$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String description() {
        return "find calls to procedures with warnings";
    }

    private ProcedureWarnings$() {
        MODULE$ = this;
        Transformer.class.$init$((Transformer)this);
        Phase.class.$init$((Phase)this);
        VisitorPhase.class.$init$((VisitorPhase)this);
    }
}

