/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.function.UncaughtCheckedException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.builtinprocs.ActiveLocksResult;
import org.neo4j.kernel.enterprise.builtinprocs.QueryId;
import org.neo4j.kernel.enterprise.builtinprocs.QueryStatusResult;
import org.neo4j.kernel.enterprise.builtinprocs.TransactionDependenciesResolver;
import org.neo4j.kernel.enterprise.builtinprocs.TransactionStatusResult;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class EnterpriseBuiltInDbmsProcedures {
    private static final int HARD_CHAR_LIMIT = 2048;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public SecurityContext securityContext;

    @Description(value="Attaches a map of data to the transaction. The data will be printed when listing queries, and inserted into the query log.")
    @Procedure(name="dbms.setTXMetaData", mode=Mode.DBMS)
    public void setTXMetaData(@Name(value="data") Map<String, Object> data) {
        this.securityContext.assertCredentialsNotExpired();
        int totalCharSize = data.entrySet().stream().mapToInt(e -> ((String)e.getKey()).length() + e.getValue().toString().length()).sum();
        if (totalCharSize >= 2048) {
            throw new IllegalArgumentException(String.format("Invalid transaction meta-data, expected the total number of chars for keys and values to be less than %d, got %d", 2048, totalCharSize));
        }
        try (Statement statement = this.getCurrentTx().acquireStatement();){
            statement.queryRegistration().setMetaData(data);
        }
    }

    @Description(value="Provides attached transaction metadata.")
    @Procedure(name="dbms.getTXMetaData", mode=Mode.DBMS)
    public Stream<MetadataResult> getTXMetaData() {
        this.securityContext.assertCredentialsNotExpired();
        try (Statement statement = this.getCurrentTx().acquireStatement();){
            Stream<MetadataResult> stream = Stream.of(statement.queryRegistration().getMetaData()).map(MetadataResult::new);
            return stream;
        }
    }

    private KernelTransaction getCurrentTx() {
        return ((ThreadToStatementContextBridge)this.graph.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    public Stream<TransactionTerminationResult> terminateTransactionsForUser(@Name(value="username") String username) {
        this.assertAdminOrSelf(username);
        return EnterpriseBuiltInDbmsProcedures.terminateTransactionsForValidUser(this.graph.getDependencyResolver(), username, this.getCurrentTx());
    }

    public Stream<ConnectionResult> listConnections() {
        this.assertAdmin();
        BoltConnectionTracker boltConnectionTracker = EnterpriseBuiltInDbmsProcedures.getBoltConnectionTracker(this.graph.getDependencyResolver());
        return EnterpriseBuiltInDbmsProcedures.countConnectionsByUsername(boltConnectionTracker.getActiveConnections().stream().filter(session -> !session.willTerminate()).map(ManagedBoltStateMachine::owner));
    }

    public Stream<ConnectionResult> terminateConnectionsForUser(@Name(value="username") String username) {
        this.assertAdminOrSelf(username);
        return EnterpriseBuiltInDbmsProcedures.terminateConnectionsForValidUser(this.graph.getDependencyResolver(), username);
    }

    @Description(value="List all user functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        this.securityContext.assertCredentialsNotExpired();
        return ((Procedures)this.graph.getDependencyResolver().resolveDependency(Procedures.class)).getAllFunctions().stream().sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new FunctionResult((UserFunctionSignature)x$0));
    }

    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        this.securityContext.assertCredentialsNotExpired();
        Procedures procedures = (Procedures)this.graph.getDependencyResolver().resolveDependency(Procedures.class);
        return procedures.getAllProcedures().stream().sorted(Comparator.comparing(a -> a.name().toString())).map(ProcedureResult::new);
    }

    @Description(value="Updates a given setting value. Passing an empty value will result in removing the configured value and falling back to the default value. Changes will not persist and will be lost if the server is restarted.")
    @Procedure(name="dbms.setConfigValue", mode=Mode.DBMS)
    public void setConfigValue(@Name(value="setting") String setting, @Name(value="value") String value) {
        this.securityContext.assertCredentialsNotExpired();
        this.assertAdmin();
        Config config = (Config)this.resolver.resolveDependency(Config.class);
        config.updateDynamicSetting(setting, value, "dbms.setConfigValue");
    }

    @Description(value="List all queries currently executing at this instance that are visible to the user.")
    @Procedure(name="dbms.listQueries", mode=Mode.DBMS)
    public Stream<QueryStatusResult> listQueries() throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        EmbeddedProxySPI nodeManager = (EmbeddedProxySPI)this.resolver.resolveDependency(EmbeddedProxySPI.class);
        ZoneId zoneId = this.getConfiguredTimeZone();
        try {
            return this.getKernelTransactions().activeTransactions().stream().flatMap(KernelTransactionHandle::executingQueries).filter(query -> this.isAdminOrSelf(query.username())).map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, query -> new QueryStatusResult((ExecutingQuery)query, nodeManager, zoneId)));
        }
        catch (UncaughtCheckedException uncaught) {
            ThrowingFunction.throwIfPresent((Optional)uncaught.getCauseIfOfType(InvalidArgumentsException.class));
            throw uncaught;
        }
    }

    @Description(value="List all transactions currently executing at this instance that are visible to the user.")
    @Procedure(name="dbms.listTransactions", mode=Mode.DBMS)
    public Stream<TransactionStatusResult> listTransactions() throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        try {
            Set handles = this.getKernelTransactions().activeTransactions().stream().filter(transaction -> this.isAdminOrSelf(transaction.subject().username())).collect(Collectors.toSet());
            Map<KernelTransactionHandle, List<QuerySnapshot>> handleQuerySnapshotsMap = handles.stream().collect(Collectors.toMap(Function.identity(), this.getTransactionQueries()));
            TransactionDependenciesResolver transactionBlockerResolvers = new TransactionDependenciesResolver(handleQuerySnapshotsMap);
            ZoneId zoneId = this.getConfiguredTimeZone();
            return handles.stream().map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, tx -> new TransactionStatusResult((KernelTransactionHandle)tx, transactionBlockerResolvers, handleQuerySnapshotsMap, zoneId)));
        }
        catch (UncaughtCheckedException uncaught) {
            ThrowingFunction.throwIfPresent((Optional)uncaught.getCauseIfOfType(InvalidArgumentsException.class));
            throw uncaught;
        }
    }

    private Function<KernelTransactionHandle, List<QuerySnapshot>> getTransactionQueries() {
        return transactionHandle -> transactionHandle.executingQueries().map(ExecutingQuery::snapshot).collect(Collectors.toList());
    }

    @Description(value="List the active lock requests granted for the transaction executing the query with the given query id.")
    @Procedure(name="dbms.listActiveLocks", mode=Mode.DBMS)
    public Stream<ActiveLocksResult> listActiveLocks(@Name(value="queryId") String queryId) throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        try {
            long id = QueryId.fromExternalString(queryId).kernelQueryId();
            return this.getActiveTransactions(tx -> this.executingQueriesWithId(id, (KernelTransactionHandle)tx)).flatMap(this::getActiveLocksForQuery);
        }
        catch (UncaughtCheckedException uncaught) {
            ThrowingFunction.throwIfPresent((Optional)uncaught.getCauseIfOfType(InvalidArgumentsException.class));
            throw uncaught;
        }
    }

    @Description(value="Kill all transactions executing the query with the given query id.")
    @Procedure(name="dbms.killQuery", mode=Mode.DBMS)
    public Stream<QueryTerminationResult> killQuery(@Name(value="id") String idText) throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        try {
            long queryId = QueryId.fromExternalString(idText).kernelQueryId();
            Set querys = this.getActiveTransactions(tx -> this.executingQueriesWithId(queryId, (KernelTransactionHandle)tx)).collect(Collectors.toSet());
            boolean killQueryVerbose = (Boolean)((Config)this.resolver.resolveDependency(Config.class)).get(GraphDatabaseSettings.kill_query_verbose);
            if (killQueryVerbose && querys.isEmpty()) {
                return Stream.builder().add(new QueryFailedTerminationResult(QueryId.fromExternalString(idText))).build();
            }
            return querys.stream().map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, this::killQueryTransaction));
        }
        catch (UncaughtCheckedException uncaught) {
            ThrowingFunction.throwIfPresent((Optional)uncaught.getCauseIfOfType(InvalidArgumentsException.class));
            throw uncaught;
        }
    }

    @Description(value="Kill all transactions executing a query with any of the given query ids.")
    @Procedure(name="dbms.killQueries", mode=Mode.DBMS)
    public Stream<QueryTerminationResult> killQueries(@Name(value="ids") List<String> idTexts) throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        try {
            Set queryIds = idTexts.stream().map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, QueryId::fromExternalString)).map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, QueryId::kernelQueryId)).collect(Collectors.toSet());
            Set terminatedQuerys = this.getActiveTransactions(tx -> this.executingQueriesWithIds(queryIds, (KernelTransactionHandle)tx)).map(ThrowingFunction.catchThrown(InvalidArgumentsException.class, this::killQueryTransaction)).collect(Collectors.toSet());
            boolean killQueryVerbose = (Boolean)((Config)this.resolver.resolveDependency(Config.class)).get(GraphDatabaseSettings.kill_query_verbose);
            if (killQueryVerbose && terminatedQuerys.size() != idTexts.size()) {
                for (String id : idTexts) {
                    if (!terminatedQuerys.stream().noneMatch(query -> query.queryId.equals(id))) continue;
                    terminatedQuerys.add(new QueryFailedTerminationResult(QueryId.fromExternalString(id)));
                }
            }
            return terminatedQuerys.stream();
        }
        catch (UncaughtCheckedException uncaught) {
            ThrowingFunction.throwIfPresent((Optional)uncaught.getCauseIfOfType(InvalidArgumentsException.class));
            throw uncaught;
        }
    }

    private <T> Stream<Pair<KernelTransactionHandle, T>> getActiveTransactions(Function<KernelTransactionHandle, Stream<T>> selector) {
        return EnterpriseBuiltInDbmsProcedures.getActiveTransactions(this.graph.getDependencyResolver()).stream().flatMap(tx -> ((Stream)selector.apply((KernelTransactionHandle)tx)).map(data -> Pair.of((Object)tx, (Object)data)));
    }

    private Stream<ExecutingQuery> executingQueriesWithIds(Set<Long> ids, KernelTransactionHandle txHandle) {
        return txHandle.executingQueries().filter(q -> ids.contains(q.internalQueryId()));
    }

    private Stream<ExecutingQuery> executingQueriesWithId(long id, KernelTransactionHandle txHandle) {
        return txHandle.executingQueries().filter(q -> q.internalQueryId() == id);
    }

    private QueryTerminationResult killQueryTransaction(Pair<KernelTransactionHandle, ExecutingQuery> pair) throws InvalidArgumentsException {
        ExecutingQuery query = (ExecutingQuery)pair.other();
        if (this.isAdminOrSelf(query.username())) {
            ((KernelTransactionHandle)pair.first()).markForTermination((Status)Status.Transaction.Terminated);
            return new QueryTerminationResult(QueryId.ofInternalId(query.internalQueryId()), query.username());
        }
        throw new AuthorizationViolationException("Permission denied.");
    }

    private Stream<ActiveLocksResult> getActiveLocksForQuery(Pair<KernelTransactionHandle, ExecutingQuery> pair) {
        ExecutingQuery query = (ExecutingQuery)pair.other();
        if (this.isAdminOrSelf(query.username())) {
            return ((KernelTransactionHandle)pair.first()).activeLocks().map(ActiveLocksResult::new);
        }
        throw new AuthorizationViolationException("Permission denied.");
    }

    private KernelTransactions getKernelTransactions() {
        return (KernelTransactions)this.resolver.resolveDependency(KernelTransactions.class);
    }

    public static Stream<TransactionTerminationResult> terminateTransactionsForValidUser(DependencyResolver dependencyResolver, String username, KernelTransaction currentTx) {
        long terminatedCount = EnterpriseBuiltInDbmsProcedures.getActiveTransactions(dependencyResolver).stream().filter(tx -> tx.subject().hasUsername(username) && !tx.isUnderlyingTransaction(currentTx)).map(tx -> tx.markForTermination((Status)Status.Transaction.Terminated)).filter(marked -> marked).count();
        return Stream.of(new TransactionTerminationResult(username, terminatedCount));
    }

    public static Stream<ConnectionResult> terminateConnectionsForValidUser(DependencyResolver dependencyResolver, String username) {
        Long killCount = EnterpriseBuiltInDbmsProcedures.getBoltConnectionTracker(dependencyResolver).getActiveConnections(username).stream().map(conn -> {
            conn.terminate();
            return true;
        }).count();
        return Stream.of(new ConnectionResult(username, killCount));
    }

    public static Set<KernelTransactionHandle> getActiveTransactions(DependencyResolver dependencyResolver) {
        return ((KernelTransactions)dependencyResolver.resolveDependency(KernelTransactions.class)).activeTransactions();
    }

    public static BoltConnectionTracker getBoltConnectionTracker(DependencyResolver dependencyResolver) {
        return (BoltConnectionTracker)dependencyResolver.resolveDependency(BoltConnectionTracker.class);
    }

    public static Stream<TransactionResult> countTransactionByUsername(Stream<String> usernames) {
        return usernames.collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> new TransactionResult((String)entry.getKey(), (Long)entry.getValue()));
    }

    public static Stream<ConnectionResult> countConnectionsByUsername(Stream<String> usernames) {
        return usernames.collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> new ConnectionResult((String)entry.getKey(), (Long)entry.getValue()));
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.resolver.resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    private boolean isAdmin() {
        return this.securityContext.isAdmin();
    }

    private void assertAdmin() {
        if (!this.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
    }

    private boolean isAdminOrSelf(String username) {
        return this.isAdmin() || this.securityContext.subject().hasUsername(username);
    }

    private void assertAdminOrSelf(String username) {
        if (!this.isAdminOrSelf(username)) {
            throw new AuthorizationViolationException("Permission denied.");
        }
    }

    public static class MetadataResult {
        public final Map<String, Object> metadata;

        MetadataResult(Map<String, Object> metadata) {
            this.metadata = metadata;
        }
    }

    public static class ConnectionResult {
        public final String username;
        public final Long connectionCount;

        ConnectionResult(String username, Long connectionCount) {
            this.username = username;
            this.connectionCount = connectionCount;
        }
    }

    public static class TransactionTerminationResult {
        public final String username;
        public final Long transactionsTerminated;

        TransactionTerminationResult(String username, Long transactionsTerminated) {
            this.username = username;
            this.transactionsTerminated = transactionsTerminated;
        }
    }

    public static class TransactionResult {
        public final String username;
        public final Long activeTransactions;

        TransactionResult(String username, Long activeTransactions) {
            this.username = username;
            this.activeTransactions = activeTransactions;
        }
    }

    public static class QueryFailedTerminationResult
    extends QueryTerminationResult {
        public QueryFailedTerminationResult(QueryId queryId) {
            super(queryId, "n/a");
            this.message = "No Query found with this id";
        }
    }

    public static class QueryTerminationResult {
        public final String queryId;
        public final String username;
        public String message = "Query found";

        public QueryTerminationResult(QueryId queryId, String username) {
            this.queryId = queryId.toString();
            this.username = username;
        }
    }

    public static class ProcedureResult {
        private static final List<String> ADMIN_PROCEDURES = Arrays.asList("createUser", "deleteUser", "listUsers", "clearAuthCache", "changeUserPassword", "addRoleToUser", "removeRoleFromUser", "suspendUser", "activateUser", "listRoles", "listRolesForUser", "listUsersForRole", "createRole", "deleteRole");
        public final String name;
        public final String signature;
        public final String description;
        public final List<String> roles;
        public final String mode;

        public ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.mode = signature.mode().toString();
            this.roles = new ArrayList<String>();
            switch (signature.mode()) {
                case DBMS: {
                    if (this.isAdminProcedure(signature.name().name())) {
                        this.roles.add("admin");
                        break;
                    }
                    this.roles.add("reader");
                    this.roles.add("editor");
                    this.roles.add("publisher");
                    this.roles.add("architect");
                    this.roles.add("admin");
                    this.roles.addAll(Arrays.asList(signature.allowed()));
                    break;
                }
                case DEFAULT: 
                case READ: {
                    this.roles.add("reader");
                }
                case WRITE: {
                    this.roles.add("editor");
                    this.roles.add("publisher");
                }
                case SCHEMA: {
                    this.roles.add("architect");
                }
                default: {
                    this.roles.add("admin");
                    this.roles.addAll(Arrays.asList(signature.allowed()));
                }
            }
        }

        private boolean isAdminProcedure(String procedureName) {
            return this.name.startsWith("dbms.security.") && ADMIN_PROCEDURES.contains(procedureName) || this.name.equals("dbms.listConfig") || this.name.equals("dbms.setConfigValue") || this.name.equals("dbms.clearQueryCaches");
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String description;
        public final List<String> roles;

        private FunctionResult(UserFunctionSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.roles = Stream.of("admin", "reader", "editor", "publisher", "architect").collect(Collectors.toList());
            this.roles.addAll(Arrays.asList(signature.allowed()));
        }
    }
}

