/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.PageLoader;

class ParallelPageLoader
implements PageLoader {
    private final PagedFile file;
    private final Executor executor;
    private final PageCache pageCache;
    private final AtomicLong received;
    private final AtomicLong processed;

    ParallelPageLoader(PagedFile file, Executor executor, PageCache pageCache) {
        this.file = file;
        this.executor = executor;
        this.pageCache = pageCache;
        this.received = new AtomicLong();
        this.processed = new AtomicLong();
    }

    @Override
    public void load(long pageId) {
        this.received.getAndIncrement();
        this.executor.execute(() -> {
            try {
                try (PageCursor cursor = this.file.io(pageId, 1);){
                    cursor.next();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.processed.getAndIncrement();
                this.pageCache.reportEvents();
            }
        });
    }

    @Override
    public void close() {
        while (this.processed.get() < this.received.get()) {
            Thread.yield();
        }
    }
}

