/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PagedFile;

final class Profile
implements Comparable<Profile> {
    private static final String PROFILE_DIR = "profiles";
    private final File profileFile;
    private final File pagedFile;
    private final long profileSequenceId;

    private Profile(File profileFile, File pagedFile, long profileSequenceId) {
        Objects.requireNonNull(profileFile);
        Objects.requireNonNull(pagedFile);
        this.profileFile = profileFile;
        this.pagedFile = pagedFile;
        this.profileSequenceId = profileSequenceId;
    }

    @Override
    public int compareTo(Profile that) {
        int compare = this.pagedFile.compareTo(that.pagedFile);
        return compare == 0 ? Long.compare(this.profileSequenceId, that.profileSequenceId) : compare;
    }

    public boolean equals(Object o) {
        if (o instanceof Profile) {
            Profile profile = (Profile)o;
            return this.profileFile.equals(profile.profileFile);
        }
        return false;
    }

    public int hashCode() {
        return this.profileFile.hashCode();
    }

    public String toString() {
        return "Profile(" + this.profileSequenceId + " for " + this.pagedFile + ")";
    }

    File file() {
        return this.profileFile;
    }

    void delete(FileSystemAbstraction fs) {
        fs.deleteFile(this.profileFile);
    }

    InputStream read(FileSystemAbstraction fs) throws IOException {
        InputStream source = fs.openAsInputStream(this.profileFile);
        try {
            return new GZIPInputStream(source);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently((AutoCloseable[])new InputStream[]{source});
            throw new IOException("Exception when building decompressor.", e);
        }
    }

    OutputStream write(FileSystemAbstraction fs) throws IOException {
        fs.mkdirs(this.profileFile.getParentFile());
        OutputStream sink = fs.openAsOutputStream(this.profileFile, false);
        try {
            return new GZIPOutputStream(sink);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently((AutoCloseable[])new OutputStream[]{sink});
            throw new IOException("Exception when building compressor.", e);
        }
    }

    Profile next() {
        long next = this.profileSequenceId + 1L;
        return new Profile(Profile.profileName(this.pagedFile, next), this.pagedFile, next);
    }

    static Profile first(File file) {
        return new Profile(Profile.profileName(file, 0L), file, 0L);
    }

    private static File profileName(File file, long count) {
        String name = file.getName();
        File dir = new File(file.getParentFile(), PROFILE_DIR);
        return new File(dir, name + "." + Long.toString(count) + ".cacheprof");
    }

    static Predicate<Profile> relevantTo(PagedFile pagedFile) {
        return p -> p.pagedFile.equals(pagedFile.file());
    }

    static Stream<Profile> findProfilesInDirectory(FileSystemAbstraction fs, File dir) {
        File[] files = fs.listFiles(new File(dir, PROFILE_DIR));
        if (files == null) {
            return Stream.empty();
        }
        return Stream.of(files).flatMap(Profile::parseProfileName);
    }

    private static Stream<Profile> parseProfileName(File profile) {
        File profileFolder = profile.getParentFile();
        File dir = profileFolder.getParentFile();
        String name = profile.getName();
        if (!name.endsWith(".cacheprof")) {
            return Stream.empty();
        }
        int lastDot = name.lastIndexOf(46);
        int secondLastDot = name.lastIndexOf(46, lastDot - 1);
        String countStr = name.substring(secondLastDot + 1, lastDot);
        try {
            long sequenceId = Long.parseLong(countStr, 10);
            String mappedFileName = name.substring(0, secondLastDot);
            return Stream.of(new Profile(profile, new File(dir, mappedFileName), sequenceId));
        }
        catch (NumberFormatException e) {
            return Stream.empty();
        }
    }
}

