/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.ha.AbstractHaRequestTypes;
import org.neo4j.kernel.ha.AquireLockCall;
import org.neo4j.kernel.ha.HaRequestTypes;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.lock.ResourceType;

public class HaRequestType210
extends AbstractHaRequestTypes {
    public HaRequestType210(LogEntryReader<ReadableClosablePositionAwareChannel> entryReader, ObjectSerializer<LockResult> lockResultObjectSerializer) {
        this.registerAllocateIds();
        this.registerCreateRelationshipType();
        this.registerAcquireExclusiveLock(lockResultObjectSerializer);
        this.registerAcquireSharedLock(lockResultObjectSerializer);
        this.registerCommit(entryReader);
        this.registerPullUpdates();
        this.registerEndLockSession();
        this.registerHandshake();
        this.registerCopyStore();
        this.registerNewLockSession();
        this.registerCreatePropertyKey();
        this.registerCreateLabel();
    }

    private void registerAllocateIds() {
        TargetCaller allocateIdTarget = (master, context, input, target) -> {
            IdType idType = IdType.values()[input.readByte()];
            return master.allocateIds(context, idType);
        };
        ObjectSerializer allocateIdSerializer = (idAllocation, result) -> {
            IdRange idRange = idAllocation.getIdRange();
            result.writeInt(idRange.getDefragIds().length);
            for (long id : idRange.getDefragIds()) {
                result.writeLong(id);
            }
            result.writeLong(idRange.getRangeStart());
            result.writeInt(idRange.getRangeLength());
            result.writeLong(idAllocation.getHighestIdInUse());
            result.writeLong(idAllocation.getDefragCount());
        };
        this.register(HaRequestTypes.Type.ALLOCATE_IDS, allocateIdTarget, allocateIdSerializer);
    }

    private void registerCreateRelationshipType() {
        TargetCaller createRelationshipTypeTarget = (master, context, input, target) -> master.createRelationshipType(context, Protocol.readString((ChannelBuffer)input));
        this.register(HaRequestTypes.Type.CREATE_RELATIONSHIP_TYPE, createRelationshipTypeTarget, Protocol.INTEGER_SERIALIZER);
    }

    private void registerAcquireExclusiveLock(ObjectSerializer<LockResult> lockResultObjectSerializer) {
        this.register(HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK, new AquireLockCall(){

            @Override
            protected Response<LockResult> lock(Master master, RequestContext context, ResourceType type, long ... ids) {
                return master.acquireExclusiveLock(context, type, ids);
            }
        }, lockResultObjectSerializer, true);
    }

    private void registerAcquireSharedLock(ObjectSerializer<LockResult> lockResultObjectSerializer) {
        this.register(HaRequestTypes.Type.ACQUIRE_SHARED_LOCK, new AquireLockCall(){

            @Override
            protected Response<LockResult> lock(Master master, RequestContext context, ResourceType type, long ... ids) {
                return master.acquireSharedLock(context, type, ids);
            }
        }, lockResultObjectSerializer, true);
    }

    private void registerCommit(LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        TargetCaller commitTarget = (master, context, input, target) -> {
            TransactionRepresentation tx;
            Protocol.readString((ChannelBuffer)input);
            try {
                Protocol.TransactionRepresentationDeserializer deserializer = new Protocol.TransactionRepresentationDeserializer(entryReader);
                tx = (TransactionRepresentation)deserializer.read(input, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return master.commit(context, tx);
        };
        this.register(HaRequestTypes.Type.COMMIT, commitTarget, Protocol.LONG_SERIALIZER);
    }

    private void registerPullUpdates() {
        TargetCaller pullUpdatesTarget = (master, context, input, target) -> master.pullUpdates(context);
        this.register(HaRequestTypes.Type.PULL_UPDATES, pullUpdatesTarget, Protocol.VOID_SERIALIZER);
    }

    private void registerEndLockSession() {
        TargetCaller endLockSessionTarget = (master, context, input, target) -> master.endLockSession(context, Protocol.readBoolean((ChannelBuffer)input));
        this.register(HaRequestTypes.Type.END_LOCK_SESSION, endLockSessionTarget, Protocol.VOID_SERIALIZER, false);
    }

    private void registerHandshake() {
        TargetCaller handshakeTarget = (master, context, input, target) -> master.handshake(input.readLong(), null);
        ObjectSerializer handshakeResultObjectSerializer = (responseObject, result) -> {
            result.writeLong(responseObject.txChecksum());
            result.writeLong(responseObject.epoch());
        };
        this.register(HaRequestTypes.Type.HANDSHAKE, handshakeTarget, handshakeResultObjectSerializer);
    }

    private void registerCopyStore() {
        TargetCaller copyStoreTarget = (master, context, input, target) -> master.copyStore(context, (StoreWriter)new ToNetworkStoreWriter(target, new Monitors()));
        this.register(HaRequestTypes.Type.COPY_STORE, copyStoreTarget, Protocol.VOID_SERIALIZER, false);
    }

    private void registerNewLockSession() {
        TargetCaller newLockSessionTarget = (master, context, input, target) -> master.newLockSession(context);
        this.register(HaRequestTypes.Type.NEW_LOCK_SESSION, newLockSessionTarget, Protocol.VOID_SERIALIZER);
    }

    private void registerCreatePropertyKey() {
        TargetCaller createPropertyKeyTarget = (master, context, input, target) -> master.createPropertyKey(context, Protocol.readString((ChannelBuffer)input));
        this.register(HaRequestTypes.Type.CREATE_PROPERTY_KEY, createPropertyKeyTarget, Protocol.INTEGER_SERIALIZER);
    }

    private void registerCreateLabel() {
        TargetCaller createLabelTarget = (master, context, input, target) -> master.createLabel(context, Protocol.readString((ChannelBuffer)input));
        this.register(HaRequestTypes.Type.CREATE_LABEL, createLabelTarget, Protocol.INTEGER_SERIALIZER);
    }
}

