/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionChecksumLookup {
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private TransactionId upgradeTransaction;

    public TransactionChecksumLookup(TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore) {
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.upgradeTransaction = transactionIdStore.getUpgradeTransaction();
    }

    public long lookup(long txId) throws IOException {
        TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
        if (lastCommittedTransaction.transactionId() == txId) {
            return lastCommittedTransaction.checksum();
        }
        if (this.upgradeTransaction.transactionId() == txId) {
            return this.upgradeTransaction.checksum();
        }
        try {
            return this.logicalTransactionStore.getMetadataFor(txId).getChecksum();
        }
        catch (NoSuchTransactionException e) {
            throw (NoSuchTransactionException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + " | transaction id store says last transaction is " + lastCommittedTransaction + " and last upgrade transaction is " + this.upgradeTransaction));
        }
    }
}

