/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class LimitedFileChannel
implements StoreChannel {
    private final StoreChannel inner;
    private final LimitedFilesystemAbstraction fs;

    public LimitedFileChannel(StoreChannel inner, LimitedFilesystemAbstraction limitedFilesystemAbstraction) {
        this.inner = inner;
        this.fs = limitedFilesystemAbstraction;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inner.read(byteBuffer);
    }

    public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.read(byteBuffers, i, i1);
    }

    public long read(ByteBuffer[] dsts) {
        return 0L;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffers, i, i1);
    }

    public long write(ByteBuffer[] srcs) {
        return 0L;
    }

    public long position() throws IOException {
        return this.inner.position();
    }

    public LimitedFileChannel position(long l) throws IOException {
        return new LimitedFileChannel(this.inner.position(l), this.fs);
    }

    public long size() throws IOException {
        return this.inner.size();
    }

    public LimitedFileChannel truncate(long l) throws IOException {
        return new LimitedFileChannel(this.inner.truncate(l), this.fs);
    }

    public void force(boolean b) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.force(b);
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.read(byteBuffer, l);
    }

    public void readAll(ByteBuffer dst) throws IOException {
        this.inner.readAll(dst);
    }

    public FileLock tryLock() throws IOException {
        return this.inner.tryLock();
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src);
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }

    public void close() throws IOException {
        this.inner.close();
    }

    public void flush() throws IOException {
        this.inner.flush();
    }
}

