/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.impl.CompositePageCursor;
import org.neo4j.test.matchers.ByteArrayMatcher;

public class CompositePageCursorTest {
    private static final int PAGE_SIZE = 16;
    private StubPageCursor first;
    private StubPageCursor second;
    private byte[] bytes = new byte[4];

    private StubPageCursor generatePage(int initialPageId, int pageSize, int initialValue) {
        StubPageCursor cursor = new StubPageCursor((long)initialPageId, pageSize);
        for (int i = 0; i < pageSize; ++i) {
            cursor.putByte(i, (byte)(initialValue + i));
        }
        return cursor;
    }

    @Before
    public void setUp() {
        this.first = this.generatePage(0, 16, 160);
        this.second = this.generatePage(2, 24, 176);
    }

    @Test
    public void getByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-95));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-79));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.setOffset(0);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)1));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.putByte((byte)2);
        c.setOffset(1);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)2));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        Assert.assertThat((Object)this.first.getByte(1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)2);
        c.putByte((byte)1);
        c.putByte((byte)2);
        Assert.assertThat((Object)this.second.getByte(1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-78));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)1);
        Assert.assertThat((Object)c.getByte(1), (Matcher)Matchers.is((Object)-94));
        Assert.assertThat((Object)c.getByte(2), (Matcher)Matchers.is((Object)-78));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putByte(1, (byte)1);
        c.putByte(2, (byte)2);
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-95));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-77));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24158));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20046));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.setOffset(0);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)1));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.putShort((short)2);
        c.setOffset(2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)2));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        Assert.assertThat((Object)this.first.getShort(1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)4);
        c.putShort((short)1);
        c.putShort((short)2);
        Assert.assertThat((Object)this.second.getShort(1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-19532));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)3, (PageCursor)this.second, (int)2);
        Assert.assertThat((Object)c.getShort(1), (Matcher)Matchers.is((Object)-23901));
        Assert.assertThat((Object)c.getShort(3), (Matcher)Matchers.is((Object)-19789));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putShort(2, (short)1);
        c.putShort(4, (short)2);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24158));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-19275));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1583176796));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1313688652));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.setOffset(0);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)1));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.putInt(2);
        c.setOffset(4);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)2));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        Assert.assertThat((Object)this.first.getInt(1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)8);
        c.putInt(1);
        c.putInt(2);
        Assert.assertThat((Object)this.second.getInt(1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1246316616));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)5, (PageCursor)this.second, (int)4);
        Assert.assertThat((Object)c.getInt(1), (Matcher)Matchers.is((Object)-1566333787));
        Assert.assertThat((Object)c.getInt(5), (Matcher)Matchers.is((Object)-1296845643));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putInt(4, 1);
        c.putInt(8, 2);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1583176796));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1229473607));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6799692559826901080L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5642249794417674312L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.setOffset(0);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)1L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.putLong(2L);
        c.setOffset(8);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)2L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        Assert.assertThat((Object)this.first.getLong(1), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)16);
        c.putLong(1L);
        c.putLong(2L);
        Assert.assertThat((Object)this.second.getLong(1), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5063528411713060928L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)9, (PageCursor)this.second, (int)8);
        Assert.assertThat((Object)c.getLong(1), (Matcher)Matchers.is((Object)-6727352386988824407L));
        Assert.assertThat((Object)c.getLong(9), (Matcher)Matchers.is((Object)-5569909621579597639L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongWithOffsetMustHitCorrectCursors() {
        this.first = this.generatePage(0, 24, 160);
        this.second = this.generatePage(0, 24, 192);
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putLong(8, 1L);
        c.putLong(16, 2L);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6799692559826901080L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-3833745473465757487L));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{161, 162, 163, 164}));
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void getBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{177, 178, 179, 180}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1, 2, 3, 4});
        c.setOffset(0);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1, 2, 3, 4}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        c.setOffset(1);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{2}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        this.first.setOffset(1);
        this.first.getBytes(this.bytes);
        Assert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1}));
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void putBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)8);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        this.second.setOffset(1);
        this.second.getBytes(this.bytes);
        Assert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{2}));
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{181, 182, 183, 184}));
        Assert.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    public void overlappingGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1364217679));
        c.setOffset(15);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20560));
        c.setOffset(12);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6003950658608057677L));
        c.setOffset(14);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{174, 175, 176, 177}));
    }

    @Test
    public void overlappingOffsettedGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assert.assertThat((Object)c.getInt(14), (Matcher)Matchers.is((Object)-1364217679));
        Assert.assertThat((Object)c.getShort(15), (Matcher)Matchers.is((Object)-20560));
        Assert.assertThat((Object)c.getLong(12), (Matcher)Matchers.is((Object)-6003950658608057677L));
    }

    @Test
    public void overlappingPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        c.putInt(16909060);
        c.setOffset(14);
        Assert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)16909060));
        c.setOffset(15);
        c.putShort((short)258);
        c.setOffset(15);
        Assert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)258));
        c.setOffset(12);
        c.putLong(72623859790382856L);
        c.setOffset(12);
        Assert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)72623859790382856L));
        c.setOffset(14);
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = (byte)(i + 1);
        }
        c.putBytes(this.bytes);
        c.setOffset(14);
        c.getBytes(this.bytes);
        Assert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1, 2, 3, 4}));
    }

    @Test
    public void overlappingOffsettedPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putInt(14, 16909060);
        Assert.assertThat((Object)c.getInt(14), (Matcher)Matchers.is((Object)16909060));
        c.putShort(15, (short)258);
        Assert.assertThat((Object)c.getShort(15), (Matcher)Matchers.is((Object)258));
        c.putLong(12, 72623859790382856L);
        Assert.assertThat((Object)c.getLong(12), (Matcher)Matchers.is((Object)72623859790382856L));
    }

    @Test
    public void closeBothCursorsOnClose() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.close();
        Assert.assertTrue((boolean)this.first.isClosed());
        Assert.assertTrue((boolean)this.second.isClosed());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void nextIsNotSupportedOperation() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void nextWithPageIdIsNotSupportedOperation() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.next(12L);
    }

    @Test
    public void rewindCompositeCursor() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong();
        pageCursor.getLong();
        pageCursor.getLong();
        pageCursor.rewind();
        Assert.assertEquals((long)0L, (long)pageCursor.getOffset());
        Assert.assertEquals((long)1L, (long)this.first.getOffset());
        Assert.assertEquals((long)2L, (long)this.second.getOffset());
    }

    @Test
    public void getOffsetMustReturnOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong();
        Assert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)8));
        pageCursor.getLong();
        pageCursor.getLong();
        Assert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)24));
    }

    @Test
    public void setOffsetMustSetOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.setOffset(13);
        Assert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)13));
        Assert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)0));
        pageCursor.setOffset(18);
        Assert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)16));
        Assert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void raisingOutOfBoundsFlagMustRaiseOutOfBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.raiseOutOfBounds();
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void currentPageSizeIsUnsupported() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getCurrentPageSize();
    }

    @Test
    public void pageIdEqualFirstCursorPageIdBeforeFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assert.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assert.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assert.assertNotEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
    }

    @Test
    public void pageIdEqualSecondCursorPageIdAfterFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assert.assertNotEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assert.assertNotEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assert.assertEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
    }

    @Test
    public void retryShouldCheckAndResetBothCursors() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assert.assertFalse((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(true);
        Assert.assertTrue((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(false);
        Assert.assertFalse((boolean)pageCursor.shouldRetry());
        this.second.setNeedsRetry(true);
        Assert.assertTrue((boolean)pageCursor.shouldRetry());
    }

    @Test
    public void retryMustResetOffsetsInBothCursors() throws Exception {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)0));
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(false);
        this.second.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void retryMustClearTheOutOfBoundsFlags() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.raiseOutOfBounds();
        this.second.raiseOutOfBounds();
        pageCursor.raiseOutOfBounds();
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assert.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void checkAndClearCompositeBoundsFlagMustClearFirstBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.raiseOutOfBounds();
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
    }

    @Test
    public void checkAndClearCompositeBoundsFlagMustClearSecondBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.raiseOutOfBounds();
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
    }

    @Test
    public void composeMustNotThrowIfFirstLengthExpandsBeyondFirstPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)Integer.MAX_VALUE, (PageCursor)this.second, (int)16);
    }

    @Test
    public void composeMustNotThrowIfSecondLengthExpandsBeyondSecondPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)Integer.MAX_VALUE);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void compositeCursorDoesNotSupportCopyTo() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.copyTo(0, (PageCursor)new StubPageCursor(0L, 7), 89, 6);
    }

    @Test
    public void getByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getByte();
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getByte(i);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte((byte)1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte(i, (byte)1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getByte(-1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putByte(-1, (byte)1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort();
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort(i);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort((short)1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort(i, (short)1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getShortOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getShort(-1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putShortOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putShort(-1, (short)1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt();
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt(i);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(i, 1);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getIntOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getInt(-1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putIntOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putInt(-1, 1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong();
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong(i);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(1L);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongOffsettedBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(i, 1L);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getLongOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong(-1);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putLongOffsettedBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putLong(-1, 1L);
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void getByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getBytes(this.bytes);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void putByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putBytes(this.bytes);
        }
        Assert.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assert.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    public void setCursorErrorMustApplyToCursorAtCurrentOffset() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        String firstMsg = "first boo";
        String secondMsg = "second boo";
        cursor.setCursorException(firstMsg);
        Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.first.checkAndClearCursorException();
            Assert.fail((String)"first checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)firstMsg));
        }
        cursor.setOffset(16);
        cursor.setCursorException(secondMsg);
        Assert.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.second.checkAndClearCursorException();
            Assert.fail((String)"second checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)secondMsg));
        }
    }

    @Test
    public void checkAndClearCursorErrorMustNotThrowIfNoErrorsAreSet() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        cursor.checkAndClearCursorException();
    }

    @Test
    public void checkAndClearCursorErrorMustThrowIfFirstCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            Assert.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
    }

    @Test
    public void checkAndClearCursorErrorMustThrowIfSecondCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            Assert.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
    }

    @Test
    public void checkAndClearCursorErrorWillOnlyCheckFirstCursorIfBothHaveErrorsSet() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        try {
            cursor.checkAndClearCursorException();
            Assert.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"first boo"));
        }
        try {
            this.second.checkAndClearCursorException();
            Assert.fail((String)"second cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"second boo"));
        }
    }

    @Test
    public void clearCursorErrorMustClearBothCursors() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        cursor.clearCursorException();
        this.first.checkAndClearCursorException();
        this.second.checkAndClearCursorException();
        cursor.checkAndClearCursorException();
    }

    @Test
    public void isWriteLockedMustBeTrueIfBothCursorsAreWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(true);
        Assert.assertTrue((boolean)cursor.isWriteLocked());
    }

    @Test
    public void isWriteLockedMustBeFalseIfBothCursorsAreNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(false);
        Assert.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    public void isWriteLockedMustBeFalseIfFirstCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(true);
        Assert.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    public void isWriteLockedMustBeFalseIfSecondCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(false);
        Assert.assertFalse((boolean)cursor.isWriteLocked());
    }
}

