/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.linear;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryTracer;

class HEvents {
    private HEvents() {
    }

    public static abstract class IntervalHEvent
    extends HEvent {
        protected LinearHistoryTracer tracer;

        IntervalHEvent(LinearHistoryTracer tracer) {
            this.tracer = tracer;
        }

        public void close() {
            this.tracer.add(new EndHEvent(this));
        }
    }

    public static abstract class HEvent {
        static final HEvent end = new HEvent(){

            @Override
            void printBody(PrintStream out, String exceptionLinePrefix) {
                out.print(" EOF ");
            }
        };
        final long time = System.nanoTime();
        final long threadId;
        final String threadName;
        volatile HEvent prev;

        HEvent() {
            Thread thread = Thread.currentThread();
            this.threadId = thread.getId();
            this.threadName = thread.getName();
            System.identityHashCode(this);
        }

        public static HEvent reverse(HEvent events) {
            HEvent current = end;
            while (events != end) {
                HEvent prev;
                while ((prev = events.prev) == null) {
                }
                events.prev = current;
                current = events;
                events = prev;
            }
            return current;
        }

        public void print(PrintStream out, String exceptionLinePrefix) {
            out.print(this.getClass().getSimpleName());
            out.print('#');
            out.print(System.identityHashCode(this));
            out.print('[');
            out.print("time:");
            out.print((this.time - HEvent.end.time) / 1000L);
            out.print(", threadId:");
            out.print(this.threadId);
            this.printBody(out, exceptionLinePrefix);
            out.print(']');
        }

        abstract void printBody(PrintStream var1, String var2);

        protected final void print(PrintStream out, File file) {
            out.print(", file:");
            out.print(file == null ? "<null>" : file.getPath());
        }

        protected final void print(PrintStream out, Throwable exception, String linePrefix) {
            if (exception != null) {
                out.println(", exception:");
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream sbuf = new PrintStream(buf);
                exception.printStackTrace(sbuf);
                sbuf.flush();
                BufferedReader reader = new BufferedReader(new StringReader(buf.toString()));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        out.print(linePrefix);
                        out.print('\t');
                        out.println(line);
                        line = reader.readLine();
                    }
                    out.print(linePrefix);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class EvictionHEvent
    extends IntervalHEvent
    implements EvictionEvent,
    FlushEventOpportunity {
        private long filePageId;
        private File file;
        private IOException exception;
        private long cachePageId;

        EvictionHEvent(LinearHistoryTracer linearHistoryTracer) {
            super(linearHistoryTracer);
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.file = swapper == null ? null : swapper.file();
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public void threwException(IOException exception) {
            this.exception = exception;
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper) {
            return this.tracer.add(new FlushHEvent(this.tracer, filePageId, cachePageId, swapper));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            this.print(out, this.file);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class PageFaultHEvent
    extends IntervalHEvent
    implements PageFaultEvent {
        private int bytesRead;
        private long cachePageId;
        private boolean pageEvictedByFaulter;
        private Throwable exception;

        PageFaultHEvent(LinearHistoryTracer linearHistoryTracer) {
            super(linearHistoryTracer);
        }

        public void addBytesRead(long bytes) {
            this.bytesRead = (int)((long)this.bytesRead + bytes);
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public void done() {
            this.close();
        }

        public void done(Throwable throwable) {
            this.exception = throwable;
            this.done();
        }

        public EvictionEvent beginEviction() {
            this.pageEvictedByFaulter = true;
            return this.tracer.add(new EvictionHEvent(this.tracer));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", bytesRead:");
            out.print(this.bytesRead);
            out.print(", pageEvictedByFaulter:");
            out.print(this.pageEvictedByFaulter);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class PinHEvent
    extends IntervalHEvent
    implements PinEvent {
        private boolean exclusiveLock;
        private long filePageId;
        private File file;
        private long cachePageId;
        private boolean hit;

        PinHEvent(LinearHistoryTracer tracer, boolean exclusiveLock, long filePageId, PageSwapper swapper) {
            super(tracer);
            this.exclusiveLock = exclusiveLock;
            this.filePageId = filePageId;
            this.hit = true;
            this.file = swapper.file();
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public PageFaultEvent beginPageFault() {
            this.hit = false;
            return this.tracer.add(new PageFaultHEvent(this.tracer));
        }

        public void hit() {
        }

        public void done() {
            this.close();
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", hit:");
            out.print(this.hit);
            this.print(out, this.file);
            out.append(", exclusiveLock:");
            out.print(this.exclusiveLock);
        }
    }

    public static class MajorFlushHEvent
    extends IntervalHEvent
    implements MajorFlushEvent,
    FlushEventOpportunity {
        private File file;

        MajorFlushHEvent(LinearHistoryTracer tracer, File file) {
            super(tracer);
            this.file = file;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper) {
            return this.tracer.add(new FlushHEvent(this.tracer, filePageId, cachePageId, swapper));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    public static class FlushHEvent
    extends IntervalHEvent
    implements FlushEvent {
        private long filePageId;
        private long cachePageId;
        private int pageCount;
        private File file;
        private int bytesWritten;
        private IOException exception;

        FlushHEvent(LinearHistoryTracer tracer, long filePageId, long cachePageId, PageSwapper swapper) {
            super(tracer);
            this.filePageId = filePageId;
            this.cachePageId = cachePageId;
            this.pageCount = 1;
            this.file = swapper.file();
        }

        public void addBytesWritten(long bytes) {
            this.bytesWritten = (int)((long)this.bytesWritten + bytes);
        }

        public void done() {
            this.close();
        }

        public void done(IOException exception) {
            this.exception = exception;
            this.done();
        }

        public void addPagesFlushed(int pageCount) {
            this.pageCount = pageCount;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", pageCount:");
            out.print(this.pageCount);
            this.print(out, this.file);
            out.print(", bytesWritten:");
            out.print(this.bytesWritten);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class EvictionRunHEvent
    extends IntervalHEvent
    implements EvictionRunEvent {
        int pagesToEvict;

        EvictionRunHEvent(LinearHistoryTracer tracer, int pagesToEvict) {
            super(tracer);
            this.pagesToEvict = pagesToEvict;
        }

        public EvictionEvent beginEviction() {
            return this.tracer.add(new EvictionHEvent(this.tracer));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", pagesToEvict:");
            out.print(this.pagesToEvict);
        }
    }

    static class UnmappedFileHEvent
    extends HEvent {
        File file;

        UnmappedFileHEvent(File file) {
            this.file = file;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    static class MappedFileHEvent
    extends HEvent {
        File file;

        MappedFileHEvent(File file) {
            this.file = file;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    static final class EndHEvent
    extends HEvent {
        private static final Map<Class<?>, String> classSimpleNameCache = new IdentityHashMap();
        IntervalHEvent event;

        EndHEvent(IntervalHEvent event) {
            this.event = event;
        }

        @Override
        public void print(PrintStream out, String exceptionLinePrefix) {
            out.print('-');
            super.print(out, exceptionLinePrefix);
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", elapsedMicros:");
            out.print((this.time - this.event.time) / 1000L);
            out.print(", endOf:");
            Class<?> eventClass = this.event.getClass();
            String className = classSimpleNameCache.computeIfAbsent(eventClass, k -> eventClass.getSimpleName());
            out.print(className);
            out.print('#');
            out.print(System.identityHashCode(this.event));
        }
    }
}

