/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.Dynamic;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.logging.Log;
import org.neo4j.test.rule.TestDirectory;

public class ConfigTest {
    private static final String ORIGIN = "test";
    private static MyMigratingSettings myMigratingSettings = new MyMigratingSettings();
    private static MySettingsWithDefaults mySettingsWithDefaults = new MySettingsWithDefaults();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ExpectedException expect = ExpectedException.none();

    private static Config Config() {
        return ConfigTest.Config(Collections.emptyMap());
    }

    private static Config Config(Map<String, String> params) {
        return Config.fromSettings(params).withConfigClasses(Arrays.asList(mySettingsWithDefaults, myMigratingSettings)).build();
    }

    @Test
    public void shouldApplyDefaults() {
        Config config = ConfigTest.Config();
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)CoreMatchers.is((Object)"Hello, World!"));
    }

    @Test
    public void shouldApplyMigrations() {
        Config config = ConfigTest.Config(MapUtil.stringMap((String[])new String[]{"old", "hello!"}));
        Assert.assertThat((Object)config.get(MyMigratingSettings.newer), (Matcher)CoreMatchers.is((Object)"hello!"));
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldNotAllowSettingInvalidValues() {
        ConfigTest.Config(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "asd"}));
        Assert.fail((String)"Expected validation to fail.");
    }

    @Test
    public void shouldBeAbleToAugmentConfig() {
        Config config = ConfigTest.Config();
        config.augment(MySettingsWithDefaults.boolSetting, "false");
        config.augment(MySettingsWithDefaults.hello, "Bye");
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.boolSetting), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)Matchers.equalTo((Object)"Bye"));
    }

    @Test
    public void augmentAnotherConfig() {
        Config config = ConfigTest.Config();
        config.augment(MySettingsWithDefaults.hello, "Hi");
        Config anotherConfig = ConfigTest.Config();
        anotherConfig.augment(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "false", MySettingsWithDefaults.hello.name(), "Bye"}));
        config.augment(anotherConfig);
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.boolSetting), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)Matchers.equalTo((Object)"Bye"));
    }

    @Test
    public void shouldWarnAndDiscardUnknownOptionsInReservedNamespaceAndPassOnBufferedLogInWithMethods() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.file("test.conf");
        Assert.assertTrue((boolean)confFile.createNewFile());
        Config config = Config.fromFile((File)confFile).withSetting(GraphDatabaseSettings.strict_config_validation, "false").withSetting("ha.jibberish", "baah").withSetting("dbms.jibberish", "booh").build();
        config.setLogger(log);
        config.augment("causal_clustering.jibberish", "baah");
        ((Log)Mockito.verify((Object)log)).warn("Unknown config option: %s", new Object[]{"dbms.jibberish"});
        ((Log)Mockito.verify((Object)log)).warn("Unknown config option: %s", new Object[]{"ha.jibberish"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void shouldLogDeprecationWarnings() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.file("test.conf");
        Assert.assertTrue((boolean)confFile.createNewFile());
        Config config = Config.fromFile((File)confFile).withSetting(MySettingsWithDefaults.oldHello, "baah").withSetting(MySettingsWithDefaults.oldSetting, "booh").withConfigClasses(Arrays.asList(mySettingsWithDefaults, myMigratingSettings, new GraphDatabaseSettings())).build();
        config.setLogger(log);
        ((Log)Mockito.verify((Object)log)).warn("%s is deprecated. Replaced by %s", new Object[]{MySettingsWithDefaults.oldHello.name(), MySettingsWithDefaults.hello.name()});
        ((Log)Mockito.verify((Object)log)).warn("%s is deprecated.", new Object[]{MySettingsWithDefaults.oldSetting.name()});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void shouldSetInternalParameter() {
        Config config = Config.builder().withSetting(MySettingsWithDefaults.secretSetting, "false").withSetting(MySettingsWithDefaults.hello, "ABC").withConfigClasses(Arrays.asList(mySettingsWithDefaults, myMigratingSettings)).build();
        Assert.assertTrue((boolean)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.secretSetting.name())).internal());
        Assert.assertFalse((boolean)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.hello.name())).internal());
    }

    @Test
    public void shouldSetDocumentedDefaultValue() {
        Config config = Config.builder().withSetting(MySettingsWithDefaults.secretSetting, "false").withSetting(MySettingsWithDefaults.hello, "ABC").withConfigClasses(Arrays.asList(new MySettingsWithDefaults(), myMigratingSettings)).build();
        Assert.assertEquals(Optional.of("<documented default value>"), (Object)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.secretSetting.name())).documentedDefaultValue());
        Assert.assertEquals(Optional.empty(), (Object)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.hello.name())).documentedDefaultValue());
    }

    @Test
    public void validatorsShouldBeCalledWhenBuilding() {
        Config.builder().withSetting(MySettingsWithDefaults.hello, "neo4j").withValidator((ConfigurationValidator)new HelloHasToBeNeo4jConfigurationValidator()).withConfigClasses(Arrays.asList(mySettingsWithDefaults, myMigratingSettings)).build();
        this.expect.expect(InvalidSettingException.class);
        this.expect.expectMessage("Setting hello has to set to neo4j");
        Config.builder().withSetting(MySettingsWithDefaults.hello, "not-neo4j").withValidator((ConfigurationValidator)new HelloHasToBeNeo4jConfigurationValidator()).withConfigClasses(Arrays.asList(mySettingsWithDefaults, myMigratingSettings)).build();
    }

    @Test
    public void identifiersFromGroup() throws Exception {
        File confFile = this.testDirectory.file("test.conf");
        Assert.assertTrue((boolean)confFile.createNewFile());
        Config config = Config.fromFile((File)confFile).withSetting(GraphDatabaseSettings.strict_config_validation, "false").withSetting("a.b.c.first.jibberish", "baah").withSetting("a.b.c.second.jibberish", "baah").withSetting("a.b.c.third.jibberish", "baah").withSetting("a.b.c.forth.jibberish", "baah").build();
        Set identifiers = config.identifiersFromGroup(GroupedSetting.class);
        HashSet<String> expectedIdentifiers = new HashSet<String>(Arrays.asList("first", "second", "third", "forth"));
        Assert.assertEquals(expectedIdentifiers, (Object)identifiers);
    }

    @Test
    public void isConfigured() {
        Config config = ConfigTest.Config();
        Assert.assertFalse((boolean)config.isConfigured(MySettingsWithDefaults.hello));
        config.augment(MySettingsWithDefaults.hello, "Hi");
        Assert.assertTrue((boolean)config.isConfigured(MySettingsWithDefaults.hello));
    }

    @Test
    public void isConfiguredShouldNotReturnTrueEvenThoughDefaultValueExists() {
        Config config = ConfigTest.Config();
        Assert.assertFalse((boolean)config.isConfigured(MySettingsWithDefaults.hello));
        Assert.assertEquals((Object)"Hello, World!", (Object)config.get(MySettingsWithDefaults.hello));
    }

    @Test
    public void withConnectorsDisabled() {
        HttpConnector httpConnector = new HttpConnector();
        BoltConnector boltConnector = new BoltConnector();
        Config config = Config.builder().withSetting(httpConnector.enabled, "true").withSetting(httpConnector.type, Connector.ConnectorType.HTTP.name()).withSetting(boltConnector.enabled, "true").withSetting(boltConnector.type, Connector.ConnectorType.BOLT.name()).withConnectorsDisabled().build();
        Assert.assertFalse((boolean)((Boolean)config.get(httpConnector.enabled)));
        Assert.assertFalse((boolean)((Boolean)config.get(boltConnector.enabled)));
    }

    @Test
    public void augmentDefaults() {
        Config config = ConfigTest.Config();
        Assert.assertEquals((Object)"Hello, World!", (Object)config.get(MySettingsWithDefaults.hello));
        config.augmentDefaults(MySettingsWithDefaults.hello, "new default");
        Assert.assertEquals((Object)"new default", (Object)config.get(MySettingsWithDefaults.hello));
    }

    @Test
    public void updateDynamicShouldLogChanges() {
        String settingName = MyDynamicSettings.boolSetting.name();
        String changedMessage = "Setting changed: '%s' changed from '%s' to '%s' via '%s'";
        Config config = Config.builder().withConfigClasses(Collections.singletonList(new MyDynamicSettings())).build();
        Log log = (Log)Mockito.mock(Log.class);
        config.setLogger(log);
        config.updateDynamicSetting(settingName, "false", ORIGIN);
        config.updateDynamicSetting(settingName, "true", ORIGIN);
        config.updateDynamicSetting(settingName, "", ORIGIN);
        InOrder order = Mockito.inOrder((Object[])new Object[]{log});
        ((Log)order.verify((Object)log)).info(changedMessage, new Object[]{settingName, "default (true)", "false", ORIGIN});
        ((Log)order.verify((Object)log)).info(changedMessage, new Object[]{settingName, "false", "true", ORIGIN});
        ((Log)order.verify((Object)log)).info(changedMessage, new Object[]{settingName, "true", "default (true)", ORIGIN});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void updateDynamicShouldThrowIfSettingIsNotDynamic() {
        Config config = Config.builder().withConfigClasses(Collections.singletonList(mySettingsWithDefaults)).build();
        this.expect.expect(IllegalArgumentException.class);
        config.updateDynamicSetting(MySettingsWithDefaults.hello.name(), "hello", ORIGIN);
    }

    @Test
    public void updateDynamicShouldInformRegisteredListeners() {
        Config config = Config.builder().withConfigClasses(Collections.singletonList(new MyDynamicSettings())).build();
        AtomicInteger counter = new AtomicInteger(0);
        config.registerDynamicUpdateListener(MyDynamicSettings.boolSetting, (previous, update) -> {
            counter.getAndIncrement();
            Assert.assertTrue((boolean)previous);
            Assert.assertFalse((boolean)update);
        });
        config.updateDynamicSetting(MyDynamicSettings.boolSetting.name(), "false", ORIGIN);
        Assert.assertThat((Object)counter.get(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void updateDynamicShouldNotAllowInvalidSettings() {
        Config config = Config.builder().withConfigClasses(Collections.singletonList(new MyDynamicSettings())).build();
        this.expect.expect(InvalidSettingException.class);
        config.updateDynamicSetting(MyDynamicSettings.boolSetting.name(), "this is not a boolean", ORIGIN);
    }

    @Test
    public void registeringUpdateListenerOnNonDynamicSettingMustThrow() {
        Config config = Config.builder().withConfigClasses(Collections.singletonList(mySettingsWithDefaults)).build();
        this.expect.expect(IllegalArgumentException.class);
        config.registerDynamicUpdateListener(MySettingsWithDefaults.hello, (a, b) -> Assert.fail((String)"never called"));
    }

    @Test
    public void updateDynamicShouldLogExceptionsFromUpdateListeners() {
        Config config = Config.builder().withConfigClasses(Collections.singletonList(new MyDynamicSettings())).build();
        IllegalStateException exception = new IllegalStateException("Boo");
        config.registerDynamicUpdateListener(MyDynamicSettings.boolSetting, (a, b) -> {
            throw exception;
        });
        Log log = (Log)Mockito.mock(Log.class);
        config.setLogger(log);
        String settingName = MyDynamicSettings.boolSetting.name();
        config.updateDynamicSetting(settingName, "", ORIGIN);
        ((Log)Mockito.verify((Object)log)).error("Failure when notifying listeners after dynamic setting change; new setting might not have taken effect: Boo", (Throwable)exception);
    }

    public static class MyDynamicSettings
    implements LoadableConfig {
        @Dynamic
        public static final Setting<Boolean> boolSetting = Settings.setting((String)"bool_setting", (Function)Settings.BOOLEAN, (String)"true");
    }

    @Group(value="a.b.c")
    private static class GroupedSetting {
        private GroupedSetting() {
        }
    }

    private static class HelloHasToBeNeo4jConfigurationValidator
    implements ConfigurationValidator {
        private HelloHasToBeNeo4jConfigurationValidator() {
        }

        public Map<String, String> validate(@Nonnull Config config, @Nonnull Log log) throws InvalidSettingException {
            if (!((String)config.get(MySettingsWithDefaults.hello)).equals("neo4j")) {
                throw new InvalidSettingException("Setting hello has to set to neo4j");
            }
            return Collections.emptyMap();
        }
    }

    public static class MySettingsWithDefaults
    implements LoadableConfig {
        public static final Setting<String> hello = Settings.setting((String)"hello", (Function)Settings.STRING, (String)"Hello, World!");
        public static final Setting<Boolean> boolSetting = Settings.setting((String)"bool_setting", (Function)Settings.BOOLEAN, (String)"true");
        @Internal
        @DocumentedDefaultValue(value="<documented default value>")
        public static final Setting<Boolean> secretSetting = Settings.setting((String)"secret_setting", (Function)Settings.BOOLEAN, (String)"true");
        @Deprecated
        @ReplacedBy(value="hello")
        public static final Setting<String> oldHello = Settings.setting((String)"old_hello", (Function)Settings.STRING, (String)"Hello, Bob");
        @Deprecated
        public static final Setting<String> oldSetting = Settings.setting((String)"some_setting", (Function)Settings.STRING, (String)"Has no replacement");
    }

    public static class MyMigratingSettings
    implements LoadableConfig {
        @Migrator
        public static ConfigurationMigrator migrator = new BaseConfigurationMigrator(){
            {
                this.add((BaseConfigurationMigrator.Migration)new BaseConfigurationMigrator.SpecificPropertyMigration("old", "Old has been replaced by newer!"){

                    public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                        rawConfiguration.put(newer.name(), value);
                    }
                });
            }
        };
        public static Setting<String> newer = Settings.setting((String)"newer", (Function)Settings.STRING, (String)"");
    }
}

