/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.CleanupRule;

public class FlippableIndexProxyTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldBeAbleToSwitchDelegate() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy other = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(FlippableIndexProxyTest.singleProxy(other));
        delegate.flip(this.noOp(), null);
        delegate.drop();
        ((IndexProxy)Mockito.verify((Object)other)).drop();
    }

    @Test
    public void shouldNotBeAbleToFlipAfterClosed() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.close();
        delegate.setFlipTarget(indexContextFactory);
        this.expectedException.expect(IndexProxyAlreadyClosedKernelException.class);
        delegate.flip(this.noOp(), null);
    }

    @Test
    public void shouldNotBeAbleToFlipAfterDrop() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy failed = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(indexContextFactory);
        delegate.drop();
        this.expectedException.expect(IndexProxyAlreadyClosedKernelException.class);
        delegate.flip(this.noOp(), this.singleFailedDelegate(failed));
    }

    @Test
    public void shouldBlockAccessDuringFlipAndThenDelegateToCorrectContext() throws Exception {
        IndexProxy contextBeforeFlip = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy contextAfterFlip = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy flippable = new FlippableIndexProxy(contextBeforeFlip);
        flippable.setFlipTarget(FlippableIndexProxyTest.singleProxy(contextAfterFlip));
        CountDownLatch triggerFinishFlip = new CountDownLatch(1);
        CountDownLatch triggerExternalAccess = new CountDownLatch(1);
        OtherThreadExecutor flippingThread = this.cleanup.add(new OtherThreadExecutor("Flipping thread", null));
        OtherThreadExecutor dropIndexThread = this.cleanup.add(new OtherThreadExecutor("Drop index thread", null));
        Future flipContextFuture = flippingThread.executeDontWait(this.startFlipAndWaitForLatchBeforeFinishing(flippable, triggerFinishFlip, triggerExternalAccess));
        Assert.assertTrue((boolean)triggerExternalAccess.await(10L, TimeUnit.SECONDS));
        Future dropIndexFuture = dropIndexThread.executeDontWait(this.dropTheIndex(flippable));
        dropIndexThread.waitUntilWaiting();
        triggerFinishFlip.countDown();
        dropIndexFuture.get(10L, TimeUnit.SECONDS);
        flipContextFuture.get(10L, TimeUnit.SECONDS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{contextBeforeFlip});
        ((IndexProxy)Mockito.verify((Object)contextAfterFlip)).drop();
    }

    @Test
    public void shouldAbortStoreScanWaitOnDrop() throws Exception {
        FakePopulatingIndexProxy delegate = new FakePopulatingIndexProxy();
        FlippableIndexProxy flipper = new FlippableIndexProxy((IndexProxy)delegate);
        OtherThreadExecutor waiter = this.cleanup.add(new OtherThreadExecutor("Waiter", null));
        Future waiting = waiter.executeDontWait(state -> flipper.awaitStoreScanCompleted());
        while (!delegate.awaitCalled) {
            Thread.sleep(10L);
        }
        flipper.drop();
        waiting.get(10L, TimeUnit.SECONDS);
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> dropTheIndex(FlippableIndexProxy flippable) throws IOException {
        return state -> {
            flippable.drop();
            return null;
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> startFlipAndWaitForLatchBeforeFinishing(FlippableIndexProxy flippable, CountDownLatch triggerFinishFlip, CountDownLatch triggerExternalAccess) {
        return state -> {
            flippable.flip(() -> {
                triggerExternalAccess.countDown();
                Assert.assertTrue((boolean)SchemaIndexTestHelper.awaitLatch(triggerFinishFlip));
                return Boolean.TRUE;
            }, null);
            return null;
        };
    }

    private Callable<Boolean> noOp() {
        return () -> Boolean.TRUE;
    }

    public static IndexProxyFactory singleProxy(IndexProxy proxy) {
        return () -> proxy;
    }

    private FailedIndexProxyFactory singleFailedDelegate(IndexProxy failed) {
        return failure -> failed;
    }

    private static class FakePopulatingIndexProxy
    extends IndexProxyAdapter {
        private volatile boolean awaitCalled;

        private FakePopulatingIndexProxy() {
        }

        @Override
        public boolean awaitStoreScanCompleted() {
            this.awaitCalled = true;
            return true;
        }
    }
}

