/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.values.storable.Value;

abstract class InMemoryIndexImplementation
extends AbstractIndexReader
implements BoundedIterable<Long> {
    InMemoryIndexImplementation(SchemaIndexDescriptor descriptor) {
        super(descriptor);
    }

    abstract void initialize();

    abstract void drop();

    public final PrimitiveLongResourceIterator seek(Value ... values) {
        return this.doIndexSeek(InMemoryIndexImplementation.encode(values));
    }

    final boolean add(long nodeId, boolean applyIdempotently, Value ... propertyValues) {
        return this.doAdd(nodeId, applyIdempotently, InMemoryIndexImplementation.encode(propertyValues));
    }

    final void remove(long nodeId, Value ... propertyValues) {
        this.doRemove(nodeId, InMemoryIndexImplementation.encode(propertyValues));
    }

    public final long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return this.doCountIndexedNodes(nodeId, InMemoryIndexImplementation.encode(propertyValues));
    }

    protected abstract long doCountIndexedNodes(long var1, Object ... var3);

    abstract PrimitiveLongResourceIterator doIndexSeek(Object ... var1);

    abstract boolean doAdd(long var1, boolean var3, Object ... var4);

    abstract void doRemove(long var1, Object ... var3);

    abstract void remove(long var1);

    abstract void iterateAll(IndexEntryIterator var1) throws Exception;

    public void close() {
    }

    private static Object[] encode(Value[] propertyValues) {
        Object[] encoded = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            encoded[i] = InMemoryIndexImplementation.encode(propertyValues[i]);
        }
        return encoded;
    }

    private static Object encode(Value value) {
        Object asObject = value.asObject();
        if (asObject instanceof Number) {
            asObject = ((Number)asObject).doubleValue();
        } else if (asObject instanceof Character) {
            asObject = asObject.toString();
        } else if (asObject.getClass().isArray()) {
            asObject = new ArrayKey(ArrayEncoder.encode((Value)value));
        }
        return asObject;
    }

    abstract InMemoryIndexImplementation snapshot();

    abstract boolean hasSameContentsAs(InMemoryIndexImplementation var1);

    protected static interface IndexEntryIterator {
        public void visitEntry(Object var1, Set<Long> var2) throws Exception;
    }

    static class ArrayKey {
        private final String arrayValue;

        private ArrayKey(String arrayValue) {
            this.arrayValue = arrayValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayKey other = (ArrayKey)o;
            return other.arrayValue.equals(this.arrayValue);
        }

        public int hashCode() {
            return this.arrayValue != null ? this.arrayValue.hashCode() : 0;
        }
    }
}

