/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingLongFunction;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.store.NodeLoadingIterator;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;

public class NodeLoadingIteratorTest {
    @Test
    public void shouldHandleAnEmptyIterator() {
        NodeLoadingIterator iterator = new NodeLoadingIterator(PrimitiveLongCollections.emptyIterator(), id -> {
            throw new IllegalStateException("");
        });
        this.assertNoMoreElements(iterator);
    }

    @Test
    public void shouldHandleANonEmptyIterator() {
        HashMap<Long, Cursor<NodeItem>> map = new HashMap<Long, Cursor<NodeItem>>(3);
        map.put(1L, this.mockCursor());
        map.put(2L, this.mockCursor());
        map.put(3L, this.mockCursor());
        PrimitiveLongIterator inner = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        NodeLoadingIterator iterator = new NodeLoadingIterator(inner, this.createMapping(map));
        for (long i = 1L; i <= 3L; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals(map.get(i), (Object)iterator.next());
        }
        this.assertNoMoreElements(iterator);
    }

    @Test
    public void shouldHandleANonEmptyIteratorWithNotFoundEntities() {
        HashMap<Long, Cursor<NodeItem>> map = new HashMap<Long, Cursor<NodeItem>>(3);
        map.put(1L, this.mockCursor());
        map.put(2L, null);
        map.put(3L, this.mockCursor());
        PrimitiveLongIterator inner = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        NodeLoadingIterator iterator = new NodeLoadingIterator(inner, this.createMapping(map));
        for (long i = 1L; i <= 2L; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals(map.get(i + (i - 1L)), (Object)iterator.next());
        }
        this.assertNoMoreElements(iterator);
    }

    private void assertNoMoreElements(NodeLoadingIterator iterator) {
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"should have thrown ");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private ThrowingLongFunction<Cursor<NodeItem>, EntityNotFoundException> createMapping(Map<Long, Cursor<NodeItem>> map) {
        return id -> {
            if (!map.containsKey(id)) {
                throw new IllegalStateException("wat!?");
            }
            Cursor cursor = (Cursor)map.get(id);
            if (cursor == null) {
                throw new EntityNotFoundException(EntityType.NODE, id);
            }
            return cursor;
        };
    }

    private Cursor<NodeItem> mockCursor() {
        return (Cursor)Mockito.mock(Cursor.class);
    }
}

