/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LargePropertiesIT {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayAndStringPropertiesWithDifferentBlockSizes() {
        String stringValue = RandomStringUtils.randomAlphanumeric((int)10000);
        byte[] arrayValue = RandomStringUtils.randomAlphanumeric((int)10000).getBytes();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.string_block_size, "1024").setConfig(GraphDatabaseSettings.array_block_size, "2048").newGraphDatabase();
        try {
            long nodeId;
            Node node;
            try (Transaction tx = db.beginTx();){
                node = db.createNode();
                nodeId = node.getId();
                node.setProperty("string", (Object)stringValue);
                node.setProperty("array", (Object)arrayValue);
                tx.success();
            }
            tx = db.beginTx();
            var7_5 = null;
            try {
                node = db.getNodeById(nodeId);
                Assert.assertEquals((Object)stringValue, (Object)node.getProperty("string"));
                Assert.assertArrayEquals((byte[])arrayValue, (byte[])((byte[])node.getProperty("array")));
                tx.success();
            }
            catch (Throwable throwable) {
                var7_5 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
    }
}

