/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;

public class TestPropertyTypes
extends AbstractNeo4jTestCase {
    private Node node1;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void createInitialNode() {
        this.node1 = this.getGraphDb().createNode();
    }

    @After
    public void deleteInitialNode() {
        this.node1.delete();
    }

    @Test
    public void testDoubleType() {
        Double dValue = 45.678;
        String key = "testdouble";
        this.node1.setProperty(key, (Object)dValue);
        this.newTransaction();
        Double propertyValue = (Double)this.node1.getProperty(key);
        Assert.assertEquals((Object)dValue, (Object)propertyValue);
        dValue = 56784.3243;
        this.node1.setProperty(key, (Object)dValue);
        this.newTransaction();
        propertyValue = (Double)this.node1.getProperty(key);
        Assert.assertEquals((Object)dValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testFloatType() {
        Float fValue = Float.valueOf(45.678f);
        String key = "testfloat";
        this.node1.setProperty(key, (Object)fValue);
        this.newTransaction();
        Float propertyValue = null;
        propertyValue = (Float)this.node1.getProperty(key);
        Assert.assertEquals((Object)fValue, (Object)propertyValue);
        fValue = Float.valueOf(5684.324f);
        this.node1.setProperty(key, (Object)fValue);
        this.newTransaction();
        propertyValue = (Float)this.node1.getProperty(key);
        Assert.assertEquals((Object)fValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLongType() {
        Long lValue = System.currentTimeMillis();
        String key = "testlong";
        this.node1.setProperty(key, (Object)lValue);
        this.newTransaction();
        Long propertyValue = null;
        propertyValue = (Long)this.node1.getProperty(key);
        Assert.assertEquals((Object)lValue, (Object)propertyValue);
        lValue = System.currentTimeMillis();
        this.node1.setProperty(key, (Object)lValue);
        this.newTransaction();
        propertyValue = (Long)this.node1.getProperty(key);
        Assert.assertEquals((Object)lValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
        this.node1.setProperty("other", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
        this.newTransaction();
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
    }

    @Test
    public void testIntType() {
        int time = (int)System.currentTimeMillis();
        Integer iValue = time;
        String key = "testing";
        this.node1.setProperty(key, (Object)iValue);
        this.newTransaction();
        Integer propertyValue = null;
        propertyValue = (Integer)this.node1.getProperty(key);
        Assert.assertEquals((Object)iValue, (Object)propertyValue);
        iValue = (int)System.currentTimeMillis();
        this.node1.setProperty(key, (Object)iValue);
        this.newTransaction();
        propertyValue = (Integer)this.node1.getProperty(key);
        Assert.assertEquals((Object)iValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
        this.node1.setProperty("other", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
        this.newTransaction();
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
    }

    @Test
    public void testByteType() {
        byte b = -79;
        Byte bValue = b;
        String key = "testbyte";
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        Byte propertyValue = null;
        propertyValue = (Byte)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        bValue = -56;
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        propertyValue = (Byte)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testShortType() {
        Short sValue = 453;
        String key = "testshort";
        this.node1.setProperty(key, (Object)sValue);
        this.newTransaction();
        Short propertyValue = null;
        propertyValue = (Short)this.node1.getProperty(key);
        Assert.assertEquals((Object)sValue, (Object)propertyValue);
        sValue = 5335;
        this.node1.setProperty(key, (Object)sValue);
        this.newTransaction();
        propertyValue = (Short)this.node1.getProperty(key);
        Assert.assertEquals((Object)sValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testCharType() {
        char c = 'c';
        Character cValue = Character.valueOf(c);
        String key = "testchar";
        this.node1.setProperty(key, (Object)cValue);
        this.newTransaction();
        Character propertyValue = null;
        propertyValue = (Character)this.node1.getProperty(key);
        Assert.assertEquals((Object)cValue, (Object)propertyValue);
        cValue = Character.valueOf('d');
        this.node1.setProperty(key, (Object)cValue);
        this.newTransaction();
        propertyValue = (Character)this.node1.getProperty(key);
        Assert.assertEquals((Object)cValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanType() {
        String key = "testbool";
        this.node1.setProperty(key, (Object)Boolean.TRUE);
        this.newTransaction();
        Boolean propertyValue = (Boolean)this.node1.getProperty(key);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)propertyValue);
        this.node1.setProperty(key, (Object)Boolean.FALSE);
        this.newTransaction();
        propertyValue = (Boolean)this.node1.getProperty(key);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testPointType() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        this.node1.setProperty(key, (Object)point);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)point, (Object)property);
    }

    @Test
    public void testPointTypeWithOneOtherProperty() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        this.node1.setProperty("prop1", (Object)1);
        this.node1.setProperty(key, (Object)point);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)point, (Object)property);
    }

    @Test
    public void testPointTypeWithTwoOtherProperties() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        this.node1.setProperty("prop1", (Object)1);
        this.node1.setProperty("prop2", (Object)2);
        this.node1.setProperty(key, (Object)point);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)point, (Object)property);
    }

    @Test
    public void test3DPointType() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 1.0, 1.0});
        String key = "location";
        this.node1.setProperty(key, (Object)point);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)point, (Object)property);
    }

    @Test
    public void test4DPointType() {
        this.thrown.expect(Exception.class);
        this.node1.setProperty("location", (Object)Values.unsafePointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0, 1.0, 1.0}));
        this.newTransaction();
    }

    @Test
    public void testPointArray() {
        Point[] array = new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 1.0, 1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{2.0, 1.0, 3.0})};
        String key = "testpointarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        Point[] propertyValue = null;
        propertyValue = (Point[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDateTypeSmallEpochDay() {
        LocalDate date = (LocalDate)DateValue.date((int)2018, (int)1, (int)31).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)date);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)date, (Object)property);
    }

    @Test
    public void testDateTypeLargeEpochDay() {
        LocalDate date = (LocalDate)DateValue.epochDate((long)0x80000000L).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)date);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)date, (Object)property);
    }

    @Test
    public void testDateArray() {
        LocalDate[] array = new LocalDate[]{(LocalDate)DateValue.date((int)2018, (int)1, (int)31).asObjectCopy(), (LocalDate)DateValue.epochDate((long)0x80000000L).asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        LocalDate[] propertyValue = (LocalDate[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLocalTimeTypeSmallNano() {
        LocalTime time = (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)0, (int)37).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)time);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)time, (Object)property);
    }

    @Test
    public void testLocalTimeTypeLargeNano() {
        LocalTime time = (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)13, (int)37).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)time);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)time, (Object)property);
    }

    @Test
    public void testLocalTimeArray() {
        LocalTime[] array = new LocalTime[]{(LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)0, (int)37).asObjectCopy(), (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)13, (int)37).asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        LocalTime[] propertyValue = (LocalTime[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLocalDateTimeType() {
        LocalDateTime dateTime = (LocalDateTime)LocalDateTimeValue.localDateTime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)dateTime);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)dateTime, (Object)property);
    }

    @Test
    public void testLocalDateTimeArray() {
        LocalDateTime[] array = new LocalDateTime[]{(LocalDateTime)LocalDateTimeValue.localDateTime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37).asObjectCopy(), (LocalDateTime)LocalDateTimeValue.localDateTime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000).asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        LocalDateTime[] propertyValue = (LocalDateTime[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testTimeType() {
        OffsetTime time = (OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)time);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)time, (Object)property);
    }

    @Test
    public void testTimeArray() {
        String key = "testarray";
        for (OffsetTime[] array : new OffsetTime[][]{{(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)0, (int)17, (int)20, (int)783478, (String)"-03:00").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)0, (int)17, (int)20, (int)783478, (String)"-03:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)1, (int)1, (int)1, (int)1, (String)"-01:00").asObjectCopy()}}) {
            this.node1.setProperty(key, (Object)array);
            this.newTransaction();
            OffsetTime[] propertyValue = (OffsetTime[])this.node1.getProperty(key);
            Assert.assertEquals((long)array.length, (long)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDurationType() {
        TemporalAmount duration = DurationValue.duration((long)57L, (long)57L, (long)57L, (long)57L).asObjectCopy();
        String key = "dt";
        this.node1.setProperty(key, (Object)duration);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)duration, (Object)property);
    }

    @Test
    public void testDurationArray() {
        TemporalAmount[] array = new TemporalAmount[]{DurationValue.duration((long)57L, (long)57L, (long)57L, (long)57L).asObjectCopy(), DurationValue.duration((long)-40L, (long)-189L, (long)-6247L, (long)-1L).asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        TemporalAmount[] propertyValue = (TemporalAmount[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDateTimeTypeWithZoneOffset() {
        DateTimeValue dateTime = DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"+01:00");
        String key = "dt";
        this.node1.setProperty(key, (Object)dateTime);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)dateTime.asObjectCopy(), (Object)property);
    }

    @Test
    public void testDateTimeArrayWithZoneOffset() {
        ZonedDateTime[] array = new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"-01:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (String)"+11:00").asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        ZonedDateTime[] propertyValue = (ZonedDateTime[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDateTimeTypeWithZoneId() {
        DateTimeValue dateTime = DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (ZoneId)ZoneId.of("Europe/Stockholm"));
        String key = "dt";
        this.node1.setProperty(key, (Object)dateTime);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)dateTime.asObjectCopy(), (Object)property);
    }

    @Test
    public void testDateTimeArrayWithZoneOffsetAndZoneID() {
        ZonedDateTime[] array = new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"-01:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (String)"+11:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (ZoneId)ZoneId.of("Europe/Stockholm")).asObjectCopy()};
        String key = "testarray";
        this.node1.setProperty(key, (Object)array);
        this.newTransaction();
        ZonedDateTime[] propertyValue = (ZonedDateTime[])this.node1.getProperty(key);
        Assert.assertEquals((long)array.length, (long)propertyValue.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testIntArray() {
        int i;
        int[] array1 = new int[]{1, 2, 3, 4, 5};
        Integer[] array2 = new Integer[]{6, 7, 8};
        String key = "testintarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        int[] propertyValue = null;
        propertyValue = (int[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (int[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testShortArray() {
        int i;
        short[] array1 = new short[]{1, 2, 3, 4, 5};
        Short[] array2 = new Short[]{(short)6, (short)7, (short)8};
        String key = "testintarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        short[] propertyValue = null;
        propertyValue = (short[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (short[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testStringArray() {
        int i;
        String[] array1 = new String[]{"a", "b", "c", "d", "e"};
        String[] array2 = new String[]{"ff", "gg", "hh"};
        String key = "teststringarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        String[] propertyValue = null;
        propertyValue = (String[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((Object)array1[i], (Object)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (String[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanArray() {
        int i;
        boolean[] array1 = new boolean[]{true, false, true, false, true};
        Boolean[] array2 = new Boolean[]{false, true, false};
        String key = "testboolarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        boolean[] propertyValue = null;
        propertyValue = (boolean[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((Object)array1[i], (Object)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (boolean[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleArray() {
        int i;
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Double[] array2 = new Double[]{6.0, 7.0, 8.0};
        String key = "testdoublearray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        double[] propertyValue = null;
        propertyValue = (double[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (double[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Double(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testFloatArray() {
        int i;
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Float[] array2 = new Float[]{Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f)};
        String key = "testfloatarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        float[] propertyValue = null;
        propertyValue = (float[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (float[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Float(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLongArray() {
        int i;
        long[] array1 = new long[]{1L, 2L, 3L, 4L, 5L};
        Long[] array2 = new Long[]{6L, 7L, 8L};
        String key = "testlongarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        long[] propertyValue = null;
        propertyValue = (long[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (long[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testByteArray() {
        int i;
        byte[] array1 = new byte[]{1, 2, 3, 4, 5};
        Byte[] array2 = new Byte[]{(byte)6, (byte)7, (byte)8};
        String key = "testbytearray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        byte[] propertyValue = null;
        propertyValue = (byte[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (byte[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testCharArray() {
        int i;
        char[] array1 = new char[]{'1', '2', '3', '4', '5'};
        Character[] array2 = new Character[]{Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8')};
        String key = "testchararray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        char[] propertyValue = null;
        propertyValue = (char[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        propertyValue = (char[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Character(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyString() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("1", (Object)2);
        node.setProperty("2", (Object)"");
        node.setProperty("3", (Object)"");
        this.newTransaction();
        Assert.assertEquals((Object)2, (Object)node.getProperty("1"));
        Assert.assertEquals((Object)"", (Object)node.getProperty("2"));
        Assert.assertEquals((Object)"", (Object)node.getProperty("3"));
    }

    @Test
    public void shouldNotBeAbleToPoisonBooleanArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new boolean[]{false, false, false}, true);
    }

    @Test
    public void shouldNotBeAbleToPoisonByteArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new byte[]{0, 0, 0}, (byte)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonShortArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new short[]{0, 0, 0}, (short)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonIntArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new int[]{0, 0, 0}, 1);
    }

    @Test
    public void shouldNotBeAbleToPoisonLongArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new long[]{0L, 0L, 0L}, 1L);
    }

    @Test
    public void shouldNotBeAbleToPoisonFloatArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new float[]{0.0f, 0.0f, 0.0f}, Float.valueOf(1.0f));
    }

    @Test
    public void shouldNotBeAbleToPoisonDoubleArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new double[]{0.0, 0.0, 0.0}, 1.0);
    }

    @Test
    public void shouldNotBeAbleToPoisonCharArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new char[]{'0', '0', '0'}, Character.valueOf('1'));
    }

    @Test
    public void shouldNotBeAbleToPoisonStringArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new String[]{"zero", "zero", "zero"}, "one");
    }

    private Object veryLongArray(Class<?> type) {
        Object array = Array.newInstance(type, 1000);
        return array;
    }

    private String[] veryLongStringArray() {
        Object[] array = new String[100];
        Arrays.fill(array, "zero");
        return array;
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongBooleanArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Boolean.TYPE), true);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongByteArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Byte.TYPE), (byte)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongShortArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Short.TYPE), (short)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongIntArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Integer.TYPE), 1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongLongArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Long.TYPE), 1L);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongFloatArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Float.TYPE), Float.valueOf(1.0f));
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongDoubleArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Double.TYPE), 1.0);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongCharArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Character.TYPE), Character.valueOf('1'));
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongStringArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongStringArray(), "one");
    }

    private void shouldNotBeAbleToPoisonArrayProperty(Object value, Object poison) {
        this.shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(value, poison);
        this.shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(value, poison);
    }

    private void shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(Object value, Object poison) {
        String key = "key";
        this.node1.setProperty(key, value);
        Object readValue = this.node1.getProperty(key);
        Array.set(readValue, 0, poison);
        Assert.assertTrue((String)String.format("Expected %s, but was %s", Strings.prettyPrint((Object)value), Strings.prettyPrint((Object)readValue)), (boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)));
    }

    private void shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(Object value, Object poison) {
        String key = "key";
        this.node1.setProperty(key, value);
        this.newTransaction();
        Object readValue = this.node1.getProperty(key);
        Array.set(readValue, 0, poison);
        Assert.assertTrue((String)String.format("Expected %s, but was %s", Strings.prettyPrint((Object)value), Strings.prettyPrint((Object)readValue)), (boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)));
    }
}

