/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TxStateTransactionDataSnapshot;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreStatement;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TxStateTransactionDataViewTest {
    private final ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
    private final Statement stmt = (Statement)Mockito.mock(Statement.class);
    private final StoreReadLayer ops = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
    private final StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
    private final KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final TransactionState state = new TxState();

    @Before
    public void setup() {
        Mockito.when((Object)this.bridge.get()).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.ops.newStatement()).thenReturn((Object)this.storeStatement);
    }

    @Test
    public void showsCreatedNodes() {
        this.state.nodeDoCreate(1L);
        this.state.nodeDoCreate(2L);
        Assert.assertThat(this.idList(this.snapshot().createdNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsDeletedNodes() throws Exception {
        this.state.nodeDoDelete(1L);
        this.state.nodeDoDelete(2L);
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(2L)).thenReturn(StubCursors.asNodeCursor(2L, 20L, StubCursors.labels(15)));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(ArgumentMatchers.eq((long)20L), (Lock)ArgumentMatchers.any(Lock.class), (AssertOpen)ArgumentMatchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(1, Values.of((Object)"p"))));
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1L)).thenReturn(StubCursors.asNodeCursor(1L, 21L, StubCursors.labels(new int[0])));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(ArgumentMatchers.eq((long)21L), (Lock)ArgumentMatchers.any(Lock.class), (AssertOpen)ArgumentMatchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue[0]));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        Mockito.when((Object)this.ops.labelGetName(15)).thenReturn((Object)"label");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((LabelEntry)Iterables.single((Iterable)snapshot.removedLabels())).label().name(), (Matcher)CoreMatchers.equalTo((Object)"label"));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedNodeProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void showsAddedRelationships() {
        this.state.relationshipDoCreate(1L, 1, 1L, 2L);
        this.state.relationshipDoCreate(2L, 1, 1L, 1L);
        Assert.assertThat(this.idList(this.snapshot().createdRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsRemovedRelationships() throws Exception {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        this.state.relationshipDoDelete(2L, 1, 1L, 1L);
        long noPropertyId = -1L;
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(1L)).thenReturn(StubCursors.asRelationshipCursor(1L, 1, 1L, 2L, noPropertyId));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(noPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue[0]));
        long propertyId = 40L;
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(2L)).thenReturn(StubCursors.asRelationshipCursor(2L, 1, 1L, 1L, propertyId));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(propertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(1, Values.of((Object)"p"))));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedRelationshipProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void correctlySaysNodeIsDeleted() {
        this.state.nodeDoDelete(1L);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1L)).thenReturn(StubCursors.asNodeCursor(1L, -1L));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(-1L, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue[0]));
        Assert.assertThat((Object)this.snapshot().isDeleted(node), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void correctlySaysRelIsDeleted() {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        Relationship rel = (Relationship)Mockito.mock(Relationship.class);
        Mockito.when((Object)rel.getId()).thenReturn((Object)1L);
        long noPropertyId = -1L;
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(1L)).thenReturn(StubCursors.asRelationshipCursor(1L, 1, 1L, 2L, noPropertyId));
        Mockito.when((Object)this.storeStatement.acquirePropertyCursor(noPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue[0]));
        Assert.assertThat((Object)this.snapshot().isDeleted(rel), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldListAddedNodePropertiesProperties() throws Exception {
        int propertyKeyId = 1;
        Value prevValue = Values.of((Object)"prevValue");
        this.state.nodeDoChangeProperty(1L, propertyKeyId, prevValue, Values.of((Object)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(propertyKeyId)).thenReturn((Object)"theKey");
        long propertyId = 20L;
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1L)).thenReturn(StubCursors.asNodeCursor(1L, propertyId, StubCursors.labels(new int[0])));
        Mockito.when((Object)this.storeStatement.acquireSinglePropertyCursor(propertyId, propertyKeyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(propertyKeyId, prevValue)));
        Iterable propertyEntries = this.snapshot().assignedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedNodeProperties() throws Exception {
        int propertyKeyId = 1;
        Value prevValue = Values.of((Object)"prevValue");
        this.state.nodeDoRemoveProperty(1L, propertyKeyId);
        Mockito.when((Object)this.ops.propertyKeyGetName(propertyKeyId)).thenReturn((Object)"theKey");
        long propertyId = 20L;
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1L)).thenReturn(StubCursors.asNodeCursor(1L, propertyId, StubCursors.labels(new int[0])));
        Mockito.when((Object)this.storeStatement.acquireSinglePropertyCursor(propertyId, propertyKeyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(propertyKeyId, prevValue)));
        Iterable propertyEntries = this.snapshot().removedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedRelationshipProperties() throws Exception {
        int propertyKeyId = 1;
        Value prevValue = Values.of((Object)"prevValue");
        this.state.relationshipDoRemoveProperty(1L, propertyKeyId);
        Mockito.when((Object)this.ops.propertyKeyGetName(propertyKeyId)).thenReturn((Object)"theKey");
        long propertyId = 40L;
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(1L)).thenReturn(StubCursors.asRelationshipCursor(1L, 0, 0L, 0L, propertyId));
        Mockito.when((Object)this.storeStatement.acquireSinglePropertyCursor(propertyId, propertyKeyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(propertyKeyId, prevValue)));
        Iterable propertyEntries = this.snapshot().removedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedRelationshipProperties() throws Exception {
        int propertyKeyId = 1;
        Value prevValue = Values.of((Object)"prevValue");
        this.state.relationshipDoReplaceProperty(1L, propertyKeyId, prevValue, Values.of((Object)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(propertyKeyId)).thenReturn((Object)"theKey");
        long propertyId = 40L;
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(1L)).thenReturn(StubCursors.asRelationshipCursor(1L, 0, 0L, 0L, propertyId));
        Mockito.when((Object)this.storeStatement.acquireSinglePropertyCursor(propertyId, propertyKeyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN)).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(propertyKeyId, prevValue)));
        Iterable propertyEntries = this.snapshot().assignedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1L)).thenReturn(StubCursors.asNodeCursor(1L));
        Iterable labelEntries = this.snapshot().assignedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Iterable labelEntries = this.snapshot().removedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void accessTransactionIdAndCommitTime() {
        long committedTransactionId = 7L;
        long commitTime = 10L;
        Mockito.when((Object)this.transaction.getTransactionId()).thenReturn((Object)committedTransactionId);
        Mockito.when((Object)this.transaction.getCommitTime()).thenReturn((Object)commitTime);
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((long)committedTransactionId, (long)transactionDataSnapshot.getTransactionId());
        Assert.assertEquals((long)commitTime, (long)transactionDataSnapshot.getCommitTime());
    }

    @Test
    public void shouldGetEmptyUsernameForAnonymousContext() {
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)AnonymousContext.read().authorize(s -> -1));
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((Object)"", (Object)transactionDataSnapshot.username());
    }

    @Test
    public void shouldAccessUsernameFromAuthSubject() {
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)authSubject.username()).thenReturn((Object)"Christof");
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)new SecurityContext(authSubject, (AccessMode)AccessMode.Static.FULL));
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((Object)"Christof", (Object)transactionDataSnapshot.username());
    }

    @Test
    public void shouldAccessEmptyMetaData() {
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((long)0L, (long)transactionDataSnapshot.metaData().size());
    }

    @Test
    public void shouldAccessExampleMetaData() {
        EmbeddedProxySPI spi = (EmbeddedProxySPI)Mockito.mock(EmbeddedProxySPI.class);
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.getMetaData()).thenReturn((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"}));
        TxStateTransactionDataSnapshot transactionDataSnapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, spi, this.ops, (StorageStatement)this.storeStatement, (KernelTransaction)transaction);
        Assert.assertEquals((long)1L, (long)transactionDataSnapshot.metaData().size());
        Assert.assertThat((String)"Expected metadata map to contain defined username", (Object)transactionDataSnapshot.metaData(), (Matcher)CoreMatchers.equalTo((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"})));
    }

    private List<Long> idList(Iterable<? extends PropertyContainer> entities) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (PropertyContainer propertyContainer : entities) {
            out.add(propertyContainer instanceof Node ? ((Node)propertyContainer).getId() : ((Relationship)propertyContainer).getId());
        }
        return out;
    }

    private TxStateTransactionDataSnapshot snapshot() {
        EmbeddedProxySPI spi = (EmbeddedProxySPI)Mockito.mock(EmbeddedProxySPI.class);
        Mockito.when((Object)spi.newNodeProxy(ArgumentMatchers.anyLong())).thenAnswer(invocation -> new NodeProxy(spi, ((Long)invocation.getArgument(0)).longValue()));
        Mockito.when((Object)spi.newRelationshipProxy(ArgumentMatchers.anyLong())).thenAnswer(invocation -> new RelationshipProxy(spi, ((Long)invocation.getArgument(0)).longValue()));
        Mockito.when((Object)spi.newRelationshipProxy(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong())).thenAnswer(invocation -> new RelationshipProxy(spi, ((Long)invocation.getArgument(0)).longValue(), ((Long)invocation.getArgument(1)).longValue(), ((Integer)invocation.getArgument(2)).intValue(), ((Long)invocation.getArgument(3)).longValue()));
        return new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, spi, this.ops, (StorageStatement)this.storeStatement, this.transaction);
    }
}

