/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cursor.RawCursor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIndexProgressor;
import org.neo4j.storageengine.api.schema.IndexProgressor;

public class LabelScanValueIndexProgressorTest {
    @Test
    public void shouldCloseExhaustedCursors() throws Exception {
        RawCursor cursor = (RawCursor)Mockito.mock(RawCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)false);
        HashSet toRemoveFrom = new HashSet();
        LabelScanValueIndexProgressor iterator = new LabelScanValueIndexProgressor(cursor, toRemoveFrom, (IndexProgressor.NodeLabelClient)Mockito.mock(IndexProgressor.NodeLabelClient.class));
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.never())).close();
        this.exhaust(iterator);
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        iterator.next();
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)toRemoveFrom.isEmpty());
    }

    private void exhaust(LabelScanValueIndexProgressor pro) {
        while (pro.next()) {
        }
    }
}

