/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Values;

public abstract class NativeNonUniqueSchemaIndexPopulatorTest<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeSchemaIndexPopulatorTest<KEY, VALUE> {
    @Test
    public void addShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        this.populator.add(Arrays.asList(updates));
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldSampleUpdatesIfConfiguredForOnlineSampling() throws Exception {
        Object[] updates;
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] scanUpdates = this.layoutUtil.someUpdates();
        this.populator.add(Arrays.asList(scanUpdates));
        Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> generator = this.layoutUtil.randomUpdateGenerator(this.random);
        updates = new Object[]{generator.next().values()[0].asObject(), generator.next().values()[0].asObject(), updates[1], generator.next().values()[0].asObject(), updates[3]};
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            long nodeId = 1000L;
            for (Object value : updates) {
                IndexEntryUpdate<SchemaIndexDescriptor> update = this.layoutUtil.add(nodeId++, Values.of((Object)value));
                updater.process(update);
                this.populator.includeSample(update);
            }
        }
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        Assert.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true);
    }
}

