/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyRecordTest {
    @Test
    public void addingDuplicatePropertyBlockShouldOverwriteExisting() {
        PropertyRecord record = new PropertyRecord(1L);
        PropertyBlock blockA = new PropertyBlock();
        blockA.setValueBlocks(new long[1]);
        blockA.setKeyIndexId(2);
        PropertyBlock blockB = new PropertyBlock();
        blockB.setValueBlocks(new long[1]);
        blockB.setKeyIndexId(2);
        record.setPropertyBlock(blockA);
        record.setPropertyBlock(blockB);
        List propertyBlocks = Iterables.asList((Iterable)record);
        Assert.assertThat((Object)propertyBlocks, (Matcher)Matchers.hasItem((Object)blockB));
        Assert.assertThat((Object)propertyBlocks, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldIterateOverBlocks() {
        PropertyRecord record = new PropertyRecord(0L);
        PropertyBlock[] blocks = new PropertyBlock[3];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = new PropertyBlock();
            record.addPropertyBlock(blocks[i]);
        }
        Iterator iterator = record.iterator();
        for (PropertyBlock block : blocks) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)block, iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldBeAbleToRemoveBlocksDuringIteration() {
        PropertyRecord record = new PropertyRecord(0L);
        HashSet<PropertyBlock> blocks = new HashSet<PropertyBlock>();
        for (int i = 0; i < 4; ++i) {
            PropertyBlock block = new PropertyBlock();
            record.addPropertyBlock(block);
            blocks.add(block);
        }
        Iterator iterator = record.iterator();
        this.assertIteratorRemoveThrowsIllegalState(iterator);
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            PropertyBlock block = (PropertyBlock)iterator.next();
            if (i % 2 != 1) continue;
            iterator.remove();
            this.assertIteratorRemoveThrowsIllegalState(iterator);
            blocks.remove(block);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals(blocks, (Object)Iterables.asSet((Iterable)record));
    }

    @Test
    public void addLoadedBlock() {
        PropertyRecord record = new PropertyRecord(42L);
        PropertyRecordTest.addBlock(record, 1, 2);
        PropertyRecordTest.addBlock(record, 3, 4);
        List blocks = Iterables.asList((Iterable)record);
        Assert.assertEquals((long)2L, (long)blocks.size());
        Assert.assertEquals((long)1L, (long)((PropertyBlock)blocks.get(0)).getKeyIndexId());
        Assert.assertEquals((long)2L, (long)((PropertyBlock)blocks.get(0)).getSingleValueInt());
        Assert.assertEquals((long)3L, (long)((PropertyBlock)blocks.get(1)).getKeyIndexId());
        Assert.assertEquals((long)4L, (long)((PropertyBlock)blocks.get(1)).getSingleValueInt());
    }

    @Test
    public void addLoadedBlockFailsWhenTooManyBlocksAdded() {
        PropertyRecord record = new PropertyRecord(42L);
        PropertyRecordTest.addBlock(record, 1, 2);
        PropertyRecordTest.addBlock(record, 3, 4);
        PropertyRecordTest.addBlock(record, 5, 6);
        PropertyRecordTest.addBlock(record, 7, 8);
        boolean validationErrorDetected = false;
        try {
            PropertyRecordTest.addBlock(record, 9, 10);
        }
        catch (AssertionError ignored) {
            validationErrorDetected = true;
        }
        Assert.assertTrue((String)"Assertion failure expected", (boolean)validationErrorDetected);
    }

    private void assertIteratorRemoveThrowsIllegalState(Iterator<PropertyBlock> iterator) {
        try {
            iterator.remove();
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void addBlock(PropertyRecord record, int key, int value) {
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)key, (Value)Values.of((Object)value), null, null, (boolean)true);
        for (long valueBlock : block.getValueBlocks()) {
            record.addLoadedBlock(valueBlock);
        }
    }
}

