/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.neo4j.kernel.impl.transaction.TransactionCounters;

class TransactionCountersChecker {
    private final long numberOfActiveReadTransactions;
    private final long numberOfActiveWriteTransactions;
    private final long numberOfActiveTransactions;
    private final long numberOfCommittedReadTransactions;
    private final long numberOfCommittedWriteTransactions;
    private final long numberOfCommittedTransactions;
    private final long numberOfRolledBackReadTransactions;
    private final long numberOfRolledBackWriteTransactions;
    private final long numberOfRolledBackTransactions;
    private final long numberOfStartedTransactions;
    private final long numberOfTerminatedReadTransactions;
    private final long numberOfTerminatedWriteTransactions;
    private final long numberOfTerminatedTransactions;
    private final long peakConcurrentNumberOfTransactions;

    TransactionCountersChecker(TransactionCounters pre) {
        this.numberOfActiveReadTransactions = pre.getNumberOfActiveReadTransactions();
        this.numberOfActiveWriteTransactions = pre.getNumberOfActiveWriteTransactions();
        this.numberOfActiveTransactions = pre.getNumberOfActiveTransactions();
        Assert.assertEquals((long)this.numberOfActiveTransactions, (long)(this.numberOfActiveReadTransactions + this.numberOfActiveWriteTransactions));
        this.numberOfCommittedReadTransactions = pre.getNumberOfCommittedReadTransactions();
        this.numberOfCommittedWriteTransactions = pre.getNumberOfCommittedWriteTransactions();
        this.numberOfCommittedTransactions = pre.getNumberOfCommittedTransactions();
        Assert.assertEquals((long)this.numberOfCommittedTransactions, (long)(this.numberOfCommittedReadTransactions + this.numberOfCommittedWriteTransactions));
        this.numberOfRolledBackReadTransactions = pre.getNumberOfRolledBackReadTransactions();
        this.numberOfRolledBackWriteTransactions = pre.getNumberOfRolledBackWriteTransactions();
        this.numberOfRolledBackTransactions = pre.getNumberOfRolledBackTransactions();
        Assert.assertEquals((long)this.numberOfRolledBackTransactions, (long)(this.numberOfRolledBackReadTransactions + this.numberOfRolledBackWriteTransactions));
        this.numberOfTerminatedReadTransactions = pre.getNumberOfTerminatedReadTransactions();
        this.numberOfTerminatedWriteTransactions = pre.getNumberOfTerminatedWriteTransactions();
        this.numberOfTerminatedTransactions = pre.getNumberOfTerminatedTransactions();
        Assert.assertEquals((long)this.numberOfTerminatedTransactions, (long)(this.numberOfTerminatedReadTransactions + this.numberOfTerminatedWriteTransactions));
        this.numberOfStartedTransactions = pre.getNumberOfStartedTransactions();
        this.peakConcurrentNumberOfTransactions = pre.getPeakConcurrentNumberOfTransactions();
    }

    public void verifyCommitted(boolean isWriteTx, TransactionCounters post) {
        this.verifyActiveAndStarted(post);
        this.verifyCommittedIncreasedBy(post, 1, isWriteTx);
        this.verifyRolledBackIncreasedBy(post, 0, isWriteTx);
        this.verifyTerminatedIncreasedBy(post, 0, isWriteTx);
    }

    public void verifyRolledBacked(boolean isWriteTx, TransactionCounters post) {
        this.verifyActiveAndStarted(post);
        this.verifyCommittedIncreasedBy(post, 0, isWriteTx);
        this.verifyRolledBackIncreasedBy(post, 1, isWriteTx);
        this.verifyTerminatedIncreasedBy(post, 0, isWriteTx);
    }

    public void verifyTerminated(boolean isWriteTx, TransactionCounters post) {
        this.verifyActiveAndStarted(post);
        this.verifyCommittedIncreasedBy(post, 0, isWriteTx);
        this.verifyRolledBackIncreasedBy(post, 1, isWriteTx);
        this.verifyTerminatedIncreasedBy(post, 1, isWriteTx);
    }

    private void verifyCommittedIncreasedBy(TransactionCounters post, int diff, boolean isWriteTx) {
        if (isWriteTx) {
            Assert.assertEquals((long)this.numberOfCommittedReadTransactions, (long)post.getNumberOfCommittedReadTransactions());
            Assert.assertEquals((long)(this.numberOfCommittedWriteTransactions + (long)diff), (long)post.getNumberOfCommittedWriteTransactions());
        } else {
            Assert.assertEquals((long)(this.numberOfCommittedReadTransactions + (long)diff), (long)post.getNumberOfCommittedReadTransactions());
            Assert.assertEquals((long)this.numberOfCommittedWriteTransactions, (long)post.getNumberOfCommittedWriteTransactions());
        }
        Assert.assertEquals((long)(this.numberOfCommittedTransactions + (long)diff), (long)post.getNumberOfCommittedTransactions());
    }

    private void verifyRolledBackIncreasedBy(TransactionCounters post, int diff, boolean isWriteTx) {
        if (isWriteTx) {
            Assert.assertEquals((long)this.numberOfRolledBackReadTransactions, (long)post.getNumberOfRolledBackReadTransactions());
            Assert.assertEquals((long)(this.numberOfRolledBackWriteTransactions + (long)diff), (long)post.getNumberOfRolledBackWriteTransactions());
        } else {
            Assert.assertEquals((long)(this.numberOfRolledBackReadTransactions + (long)diff), (long)post.getNumberOfRolledBackReadTransactions());
            Assert.assertEquals((long)this.numberOfRolledBackWriteTransactions, (long)post.getNumberOfRolledBackWriteTransactions());
        }
        Assert.assertEquals((long)(this.numberOfRolledBackTransactions + (long)diff), (long)post.getNumberOfRolledBackTransactions());
    }

    private void verifyTerminatedIncreasedBy(TransactionCounters post, int diff, boolean isWriteTx) {
        if (isWriteTx) {
            Assert.assertEquals((long)this.numberOfTerminatedReadTransactions, (long)post.getNumberOfTerminatedReadTransactions());
            Assert.assertEquals((long)(this.numberOfTerminatedWriteTransactions + (long)diff), (long)post.getNumberOfTerminatedWriteTransactions());
        } else {
            Assert.assertEquals((long)(this.numberOfTerminatedReadTransactions + (long)diff), (long)post.getNumberOfTerminatedReadTransactions());
            Assert.assertEquals((long)this.numberOfTerminatedWriteTransactions, (long)post.getNumberOfTerminatedWriteTransactions());
        }
        Assert.assertEquals((long)(this.numberOfTerminatedTransactions + (long)diff), (long)post.getNumberOfTerminatedTransactions());
    }

    private void verifyActiveAndStarted(TransactionCounters post) {
        Assert.assertEquals((long)this.numberOfActiveReadTransactions, (long)post.getNumberOfActiveReadTransactions());
        Assert.assertEquals((long)this.numberOfActiveWriteTransactions, (long)post.getNumberOfActiveWriteTransactions());
        Assert.assertEquals((long)this.numberOfActiveTransactions, (long)post.getNumberOfActiveTransactions());
        Assert.assertEquals((long)(this.numberOfStartedTransactions + 1L), (long)post.getNumberOfStartedTransactions());
        Assert.assertEquals((long)Math.max(1L, this.peakConcurrentNumberOfTransactions), (long)post.getPeakConcurrentNumberOfTransactions());
    }
}

