/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdTestSupport;

public class CheckPointThresholdTest
extends CheckPointThresholdTestSupport {
    @Test
    public void mustCreateThresholdThatTriggersAfterTransactionCount() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx - 1), this.notTriggered));
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded((long)this.intervalTx.intValue(), this.notTriggered));
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx + 1), this.triggered));
        this.verifyTriggered("count");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustCreateThresholdThatTriggersAfterTime() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L);
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, this.notTriggered));
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, this.triggered));
        this.verifyTriggered("time");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustNotTriggerBeforeTimeWithTooFewCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(50L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
    }

    @Test
    public void mustTriggerWhenTimeThresholdIsReachedAndThereAreCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded(42L, this.triggered));
        this.verifyTriggered("time");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustNotTriggerWhenTimeThresholdIsReachedAndThereAreNoCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(42L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustNotTriggerPastTimeThresholdSinceLastCheckpointWithNoNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustTriggerPastTimeThresholdSinceLastCheckpointWithNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded(43L, this.triggered));
        this.verifyTriggered("time");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustNotTriggerOnTransactionCountWhenThereAreNoNewTransactions() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, this.notTriggered));
    }

    @Test
    public void mustNotTriggerOnTransactionCountWhenCountIsBellowThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(3L, this.notTriggered));
    }

    @Test
    public void mustTriggerOnTransactionCountWhenCountIsAtThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, this.triggered));
        this.verifyTriggered("count");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void mustNotTriggerOnTransactionCountAtThresholdIfCheckPointAlreadyHappened() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(4L, this.notTriggered));
    }

    @Test
    public void mustNotTriggerWhenTransactionCountIsWithinThresholdSinceLastTrigger() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assert.assertFalse((boolean)threshold.isCheckPointingNeeded(5L, this.notTriggered));
    }

    @Test
    public void mustTriggerOnTransactionCountWhenCountIsAtThresholdSinceLastCheckPoint() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assert.assertTrue((boolean)threshold.isCheckPointingNeeded(6L, this.triggered));
        this.verifyTriggered("count");
        this.verifyNoMoreTriggers();
    }

    @Test
    public void timeBasedThresholdMustSuggestSchedulingFrequency() {
        Assert.assertThat((Object)this.createThreshold().checkFrequencyMillis(), (Matcher)Matchers.is((Object)CheckPointThreshold.DEFAULT_CHECKING_FREQUENCY_MILLIS));
        this.withIntervalTime("100ms");
        Assert.assertThat((Object)this.createThreshold().checkFrequencyMillis(), (Matcher)Matchers.is((Object)100L));
    }
}

