/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.test.rule.TestDirectory;

public class ConvertersTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldSortFilesByNumberCleverly() throws Exception {
        File file1 = this.existenceOfFile("file1");
        File file123 = this.existenceOfFile("file123");
        File file12 = this.existenceOfFile("file12");
        File file2 = this.existenceOfFile("file2");
        File file32 = this.existenceOfFile("file32");
        Object[] files = (File[])Converters.regexFiles((boolean)true).apply(this.directory.file("file.*").getAbsolutePath());
        Assert.assertArrayEquals((Object[])new File[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    @Test
    public void canProcessPortFromAGivenString() {
        String addressWithPorts = "hostname:1234";
        Optional port = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithPorts).getPort();
        Assert.assertTrue((boolean)port.isPresent());
        Assert.assertEquals((Object)1234, port.get());
    }

    @Test
    public void emptyOptionalWhenPortIsMissing() {
        String addressWithoutPorts = "hostname";
        Optional port = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithoutPorts).getPort();
        Assert.assertFalse((boolean)port.isPresent());
    }

    @Test
    public void canProcessHostnameFromAGivenAddress() {
        String addressWithPorts = "hostname:1234";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithPorts).getHostname();
        Assert.assertTrue((boolean)hostname.isPresent());
        Assert.assertEquals((Object)"hostname", hostname.get());
    }

    @Test
    public void canProcessHostnameWithoutPort() {
        String addressWithoutPort = "hostname";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)addressWithoutPort).getHostname();
        Assert.assertTrue((boolean)hostname.isPresent());
        Assert.assertEquals((Object)"hostname", hostname.get());
    }

    @Test
    public void emptyOptionalWhenOnlyPort() {
        String portOnlyAddress = ":1234";
        Optional hostname = Converters.toOptionalHostnamePortFromRawAddress((String)portOnlyAddress).getHostname();
        Assert.assertFalse((boolean)hostname.isPresent());
    }

    private File existenceOfFile(String name) throws IOException {
        File file = this.directory.file(name);
        file.createNewFile();
        return file;
    }
}

