/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.SilentFileWatcher;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.util.watcher.DefaultFileSystemWatcherService;
import org.neo4j.scheduler.JobScheduler;

public class DefaultFileSystemWatcherServiceTest {
    private static CentralJobScheduler jobScheduler;
    private FileWatcher fileWatcher = (FileWatcher)Mockito.mock(FileWatcher.class);

    @BeforeClass
    public static void setUp() {
        jobScheduler = new CentralJobScheduler();
    }

    @AfterClass
    public static void tearDown() {
        jobScheduler.shutdown();
    }

    @Test
    public void startMonitoringWhenLifecycleStarting() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        TestFileWatcher watcher = new TestFileWatcher(latch);
        DefaultFileSystemWatcherService service = new DefaultFileSystemWatcherService((JobScheduler)jobScheduler, (FileWatcher)watcher);
        service.init();
        service.start();
        latch.await();
    }

    @Test
    public void stopMonitoringWhenLifecycleStops() throws Throwable {
        DefaultFileSystemWatcherService service = new DefaultFileSystemWatcherService((JobScheduler)jobScheduler, this.fileWatcher);
        service.init();
        service.start();
        service.stop();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).stopWatching();
    }

    @Test
    public void closeFileWatcherOnShutdown() throws Throwable {
        DefaultFileSystemWatcherService service = new DefaultFileSystemWatcherService((JobScheduler)jobScheduler, this.fileWatcher);
        service.init();
        service.start();
        service.stop();
        service.shutdown();
        ((FileWatcher)Mockito.verify((Object)this.fileWatcher)).close();
    }

    private static class TestFileWatcher
    extends SilentFileWatcher {
        private CountDownLatch latch;

        TestFileWatcher(CountDownLatch latch) {
            this.latch = latch;
        }

        public void startWatching() {
            this.latch.countDown();
        }
    }
}

