/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.Map;
import org.junit.Test;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class TestCopyOnWriteHashMap {
    @Test
    public void keySetUnaffectedByChanges() {
        CopyOnWriteHashMap map = new CopyOnWriteHashMap();
        map.put(0, "0");
        map.put(1, "1");
        map.put(2, "2");
        TraversalTestBase.assertContains(map.keySet(), 0, 1, 2);
        Iterator keys = map.keySet().iterator();
        map.remove(1);
        TraversalTestBase.assertContains(keys, 0, 1, 2);
    }

    @Test
    public void entrySetUnaffectedByChanges() {
        CopyOnWriteHashMap map = new CopyOnWriteHashMap();
        map.put(0, "0");
        map.put(1, "1");
        map.put(2, "2");
        Map.Entry[] allEntries = map.entrySet().toArray(new Map.Entry[0]);
        TraversalTestBase.assertContains(map.entrySet(), allEntries);
        Iterator entries = map.entrySet().iterator();
        map.remove(1);
        TraversalTestBase.assertContains(entries, allEntries);
    }
}

