/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.time.Clock;
import java.util.function.Function;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class NeoStoreDataSourceRule
extends ExternalResource {
    private NeoStoreDataSource dataSource;

    public NeoStoreDataSource getDataSource(File storeDir, FileSystemAbstraction fs, PageCache pageCache) {
        return this.getDataSource(storeDir, fs, pageCache, (DependencyResolver)new Dependencies());
    }

    public NeoStoreDataSource getDataSource(File storeDir, FileSystemAbstraction fs, PageCache pageCache, DependencyResolver otherCustomOverriddenDependencies) {
        this.shutdownAnyRunning();
        StatementLocksFactory locksFactory = (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class);
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)locks);
        Mockito.when((Object)statementLocks.pessimistic()).thenReturn((Object)locks);
        Mockito.when((Object)locksFactory.newInstance()).thenReturn((Object)statementLocks);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS);
        Monitors monitors = new Monitors();
        Dependencies mutableDependencies = new Dependencies(otherCustomOverriddenDependencies);
        Config config = this.dependency(mutableDependencies, Config.class, deps -> Config.defaults());
        LogService logService = this.dependency(mutableDependencies, LogService.class, deps -> new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance()));
        IdGeneratorFactory idGeneratorFactory = this.dependency(mutableDependencies, IdGeneratorFactory.class, deps -> new DefaultIdGeneratorFactory(fs));
        IdTypeConfigurationProvider idConfigurationProvider = this.dependency(mutableDependencies, IdTypeConfigurationProvider.class, deps -> new CommunityIdTypeConfigurationProvider());
        DatabaseHealth databaseHealth = this.dependency(mutableDependencies, DatabaseHealth.class, deps -> new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(DatabaseHealth.class)));
        SystemNanoClock clock = this.dependency(mutableDependencies, SystemNanoClock.class, deps -> Clocks.nanoClock());
        TransactionMonitor transactionMonitor = this.dependency(mutableDependencies, TransactionMonitor.class, deps -> new TransactionStats());
        AvailabilityGuard availabilityGuard = this.dependency(mutableDependencies, AvailabilityGuard.class, deps -> new AvailabilityGuard((Clock)deps.resolveDependency(SystemNanoClock.class), (Log)NullLog.getInstance()));
        this.dataSource = new NeoStoreDataSource(storeDir, config, idGeneratorFactory, logService, (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), this.dependencyResolverForNoIndexProvider(), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), locksFactory, (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, fs, transactionMonitor, databaseHealth, (LogFileCreationMonitor)Mockito.mock(LogFileCreationMonitor.class), TransactionHeaderInformationFactory.DEFAULT, new StartupStatisticsProvider(), (CommitProcessFactory)new CommunityCommitProcessFactory(), (AutoIndexing)Mockito.mock(InternalAutoIndexing.class), pageCache, (ConstraintSemantics)new StandardConstraintSemantics(), monitors, new Tracers("null", (Log)NullLog.getInstance(), monitors, jobScheduler, clock), (Procedures)Mockito.mock(Procedures.class), IOLimiter.unlimited(), availabilityGuard, clock, (AccessCapability)new CanWrite(), new StoreCopyCheckPointMutex(), RecoveryCleanupWorkCollector.IMMEDIATE, (IdController)new BufferedIdController(new BufferingIdGeneratorFactory(idGeneratorFactory, IdReuseEligibility.ALWAYS, idConfigurationProvider), jobScheduler), OperationalMode.single, (VersionContextSupplier)new TransactionVersionContextSupplier(), CollectionsFactorySupplier.ON_HEAP);
        return this.dataSource;
    }

    private <T> T dependency(Dependencies dependencies, Class<T> type, Function<DependencyResolver, T> defaultSupplier) {
        try {
            return (T)dependencies.resolveDependency(type);
        }
        catch (IllegalArgumentException | UnsatisfiedDependencyException e) {
            return (T)dependencies.satisfyDependency(defaultSupplier.apply((DependencyResolver)dependencies));
        }
    }

    private void shutdownAnyRunning() {
        if (this.dataSource != null) {
            this.dataSource.stop();
            this.dataSource.shutdown();
        }
    }

    protected void after(boolean successful) {
        this.shutdownAnyRunning();
    }

    private DependencyResolver dependencyResolverForNoIndexProvider() {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (IndexProvider.class.isAssignableFrom(type)) {
                    return type.cast(IndexProvider.EMPTY);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

