/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.util.function.Function;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.test.rule.ExternalResource;

public class RecordStorageEngineRule
extends ExternalResource {
    private final LifeSupport life = new LifeSupport();

    protected void before() throws Throwable {
        super.before();
        this.life.start();
    }

    public Builder getWith(FileSystemAbstraction fs, PageCache pageCache) {
        return new Builder(fs, pageCache);
    }

    private RecordStorageEngine get(FileSystemAbstraction fs, PageCache pageCache, IndexProvider indexProvider, DatabaseHealth databaseHealth, File storeDirectory, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer, Monitors monitors) {
        if (!fs.fileExists(storeDirectory) && !fs.mkdir(storeDirectory)) {
            throw new IllegalStateException();
        }
        EphemeralIdGenerator.Factory idGeneratorFactory = new EphemeralIdGenerator.Factory();
        ExplicitIndexProviderLookup explicitIndexProviderLookup = (ExplicitIndexProviderLookup)Mockito.mock(ExplicitIndexProviderLookup.class);
        Mockito.when((Object)explicitIndexProviderLookup.all()).thenReturn((Object)Iterables.empty());
        IndexConfigStore indexConfigStore = new IndexConfigStore(storeDirectory, fs);
        JobScheduler scheduler = (JobScheduler)this.life.add((Lifecycle)new CentralJobScheduler());
        Config config = Config.defaults();
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)idGeneratorFactory, IdReuseEligibility.ALWAYS, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
        return (RecordStorageEngine)this.life.add((Lifecycle)new ExtendedRecordStorageEngine(storeDirectory, config, pageCache, fs, (LogProvider)NullLogProvider.getInstance(), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), (SchemaState)Mockito.mock(SchemaState.class), (ConstraintSemantics)new StandardConstraintSemantics(), scheduler, (TokenNameLookup)Mockito.mock(TokenNameLookup.class), (LockService)new ReentrantLockService(), indexProvider, IndexingService.NO_MONITOR, databaseHealth, explicitIndexProviderLookup, indexConfigStore, (IdOrderingQueue)new SynchronizedArrayIdOrderingQueue(20), idGeneratorFactory, (IdController)new BufferedIdController(bufferingIdGeneratorFactory, scheduler), transactionApplierTransformer, monitors, RecoveryCleanupWorkCollector.IMMEDIATE, OperationalMode.single));
    }

    protected void after(boolean successful) throws Throwable {
        this.life.shutdown();
        super.after(successful);
    }

    private static class ExtendedRecordStorageEngine
    extends RecordStorageEngine {
        private final Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer;

        ExtendedRecordStorageEngine(File storeDir, Config config, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, SchemaState schemaState, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, IndexProvider indexProvider, IndexingService.Monitor indexingServiceMonitor, DatabaseHealth databaseHealth, ExplicitIndexProviderLookup explicitIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue explicitIndexTransactionOrdering, IdGeneratorFactory idGeneratorFactory, IdController idController, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, OperationalMode operationalMode) {
            super(storeDir, config, pageCache, fs, logProvider, propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, schemaState, constraintSemantics, scheduler, tokenNameLookup, lockService, (IndexProviderMap)new DefaultIndexProviderMap(indexProvider), indexingServiceMonitor, databaseHealth, explicitIndexProviderLookup, indexConfigStore, explicitIndexTransactionOrdering, idGeneratorFactory, idController, monitors, recoveryCleanupWorkCollector, operationalMode, EmptyVersionContextSupplier.EMPTY);
            this.transactionApplierTransformer = transactionApplierTransformer;
        }

        protected BatchTransactionApplierFacade applier(TransactionApplicationMode mode) {
            BatchTransactionApplierFacade recordEngineApplier = super.applier(mode);
            return this.transactionApplierTransformer.apply(recordEngineApplier);
        }
    }

    public class Builder {
        private final FileSystemAbstraction fs;
        private final PageCache pageCache;
        private DatabaseHealth databaseHealth = new DatabaseHealth(new DatabasePanicEventGenerator(new KernelEventHandlers((Log)NullLog.getInstance())), (Log)NullLog.getInstance());
        private File storeDirectory = new File("/graph.db");
        private Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer = applierFacade -> applierFacade;
        private IndexProvider indexProvider = IndexProvider.EMPTY;
        private Monitors monitors = new Monitors();

        public Builder(FileSystemAbstraction fs, PageCache pageCache) {
            this.fs = fs;
            this.pageCache = pageCache;
        }

        public Builder transactionApplierTransformer(Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer) {
            this.transactionApplierTransformer = transactionApplierTransformer;
            return this;
        }

        public Builder indexProvider(IndexProvider indexProvider) {
            this.indexProvider = indexProvider;
            return this;
        }

        public Builder databaseHealth(DatabaseHealth databaseHealth) {
            this.databaseHealth = databaseHealth;
            return this;
        }

        public Builder storeDirectory(File storeDirectory) {
            this.storeDirectory = storeDirectory;
            return this;
        }

        public Builder monitors(Monitors monitors) {
            this.monitors = monitors;
            return this;
        }

        public RecordStorageEngine build() {
            return RecordStorageEngineRule.this.get(this.fs, this.pageCache, this.indexProvider, this.databaseHealth, this.storeDirectory, this.transactionApplierTransformer, this.monitors);
        }
    }
}

