/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;

@ManagementInterface(name="Page cache")
@Description(value="Information about the Neo4j page cache. All numbers are counts and sums since the Neo4j instance was started")
public interface PageCache {
    public static final String NAME = "Page cache";

    @Description(value="Number of page faults. How often requested data was not found in memory and had to be loaded.")
    public long getFaults();

    @Description(value="Number of page evictions. How many pages have been removed from memory to make room for other pages.")
    public long getEvictions();

    @Description(value="Number of page pins. How many pages have been accessed (monitoring must be enabled separately).")
    public long getPins();

    @Description(value="Number of page flushes. How many dirty pages have been written to durable storage.")
    public long getFlushes();

    @Description(value="Number of bytes read from durable storage.")
    public long getBytesRead();

    @Description(value="Number of bytes written to durable storage.")
    public long getBytesWritten();

    @Description(value="Number of files that have been mapped into the page cache.")
    public long getFileMappings();

    @Description(value="Number of files that have been unmapped from the page cache.")
    public long getFileUnmappings();

    @Description(value="Number of exceptions caught during page eviction. This number should be zero, or at least not growing, in a healthy database. Otherwise it could indicate drive failure, storage space, or permission problems.")
    public long getEvictionExceptions();

    @Description(value="The percentage of used pages. Will return NaN if it cannot be determined.")
    default public double getUsageRatio() {
        return Double.NaN;
    }

    @Description(value="Ratio of hits to the total number of lookups in the page cache")
    default public double getHitRatio() {
        return Double.NaN;
    }
}

