/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.neo4j.metrics.source.jvm.JvmMetrics;

public class ThreadMetrics
extends JvmMetrics {
    public static final String THREAD_COUNT = MetricRegistry.name((String)"vm", (String[])new String[]{"thread.count"});
    public static final String THREAD_TOTAL = MetricRegistry.name((String)"vm", (String[])new String[]{"thread.total"});
    private final MetricRegistry registry;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void start() {
        this.registry.register(THREAD_COUNT, (Metric)((Gauge)Thread::activeCount));
        this.registry.register(THREAD_TOTAL, (Metric)((Gauge)this.threadMXBean::getThreadCount));
    }

    public void stop() {
        this.registry.remove(THREAD_COUNT);
        this.registry.remove(THREAD_TOTAL);
    }
}

