/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.SortedSet;
import java.util.TreeSet;
import org.neo4j.server.security.auth.FileRepositorySerializer;
import org.neo4j.server.security.auth.exception.FormatException;
import org.neo4j.server.security.enterprise.auth.RoleRecord;

public class RoleSerialization
extends FileRepositorySerializer<RoleRecord> {
    private static final String roleSeparator = ":";
    private static final String userSeparator = ",";

    protected String serialize(RoleRecord role) {
        return String.join((CharSequence)roleSeparator, role.name(), String.join((CharSequence)userSeparator, role.users()));
    }

    protected RoleRecord deserializeRecord(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(roleSeparator, -1);
        if (parts.length != 2) {
            throw new FormatException(String.format("wrong number of line fields [line %d]", lineNumber));
        }
        return new RoleRecord.Builder().withName(parts[0]).withUsers(this.deserializeUsers(parts[1])).build();
    }

    private SortedSet<String> deserializeUsers(String part) {
        String[] splits = part.split(userSeparator, -1);
        TreeSet<String> users = new TreeSet<String>();
        for (String user : splits) {
            if (user.trim().isEmpty()) continue;
            users.add(user);
        }
        return users;
    }
}

