/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientGroupContext;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;

public class MaintainUtils {
    private static final Logger log = LoggerFactory.getLogger(MaintainUtils.class);
    public static final String TEMP_DIR = "tiotemp/";

    public static void remove(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.groupContext;
        if (!groupContext.isServer()) {
            ClientGroupContext clientGroupContext = (ClientGroupContext)groupContext;
            clientGroupContext.closeds.remove((Object)channelContext);
            clientGroupContext.connecteds.remove((Object)channelContext);
        }
        groupContext.connections.remove((Object)channelContext);
        groupContext.ips.unbind(channelContext);
        groupContext.ids.unbind(channelContext);
        MaintainUtils.close(channelContext);
    }

    public static void close(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.groupContext;
        groupContext.users.unbind(channelContext);
        groupContext.tokens.unbind(channelContext);
        groupContext.groups.unbind(channelContext);
        groupContext.bsIds.unbind(channelContext);
        MaintainUtils.deleteTempDir(channelContext);
    }

    public static Set<ChannelContext> createSet(Comparator<ChannelContext> comparator) {
        if (comparator == null) {
            return new HashSet<ChannelContext>();
        }
        return new TreeSet<ChannelContext>(comparator);
    }

    public static void deleteTempDir(ChannelContext channelContext) {
        try {
            String dir = channelContext.getId();
            File dirFile = new File(TEMP_DIR + dir);
            dirFile.deleteOnExit();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public static File createTempDir(ChannelContext channelContext) {
        String dir = channelContext.getId();
        File dirFile = new File(TEMP_DIR + dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        return dirFile;
    }

    public static File tempReceivedFile(ChannelContext channelContext) {
        File tempDir = MaintainUtils.createTempDir(channelContext);
        File tempReceivedFile = new File(tempDir, "received");
        return tempReceivedFile;
    }

    public static File tempWriteFile(ChannelContext channelContext) {
        File tempDir = MaintainUtils.createTempDir(channelContext);
        File tempReceivedFile = new File(tempDir, "write");
        return tempReceivedFile;
    }
}

