/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.utils.SystemTimer;

public class ChannelStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    public int decodeFailCount = 0;
    public long latestTimeOfReceivedPacket = SystemTimer.currTime;
    public long latestTimeOfSentPacket = SystemTimer.currTime;
    public long latestTimeOfReceivedByte = SystemTimer.currTime;
    public long latestTimeOfSentByte = SystemTimer.currTime;
    public long timeCreated = System.currentTimeMillis();
    public Long timeFirstConnected = null;
    public long timeClosed = SystemTimer.currTime;
    public long timeInReconnQueue = SystemTimer.currTime;
    public final AtomicLong sentBytes = new AtomicLong();
    public final AtomicLong sentPackets = new AtomicLong();
    public final AtomicLong handledBytes = new AtomicLong();
    public final AtomicLong handledPackets = new AtomicLong();
    public final AtomicLong handledPacketCosts = new AtomicLong();
    public final AtomicLong receivedBytes = new AtomicLong();
    public final AtomicLong receivedTcps = new AtomicLong();
    public final AtomicLong receivedPackets = new AtomicLong();

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public int getDecodeFailCount() {
        return this.decodeFailCount;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public long getLatestTimeOfReceivedPacket() {
        return this.latestTimeOfReceivedPacket;
    }

    public long getLatestTimeOfSentPacket() {
        return this.latestTimeOfSentPacket;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public long getTimeClosed() {
        return this.timeClosed;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Long getTimeFirstConnected() {
        return this.timeFirstConnected;
    }

    public long getTimeInReconnQueue() {
        return this.timeInReconnQueue;
    }

    public void setLatestTimeOfSentPacket(long latestTimeOfSentPacket) {
        this.latestTimeOfSentPacket = latestTimeOfSentPacket;
    }

    public void setTimeClosed(long timeClosed) {
        this.timeClosed = timeClosed;
    }

    public void setTimeFirstConnected(Long timeFirstConnected) {
        this.timeFirstConnected = timeFirstConnected;
    }

    public void setTimeInReconnQueue(long timeInReconnQueue) {
        this.timeInReconnQueue = timeInReconnQueue;
    }

    public long getLatestTimeOfReceivedByte() {
        return this.latestTimeOfReceivedByte;
    }

    public void setLatestTimeOfReceivedByte(long latestTimeOfReceivedByte) {
        this.latestTimeOfReceivedByte = latestTimeOfReceivedByte;
    }

    public long getLatestTimeOfSentByte() {
        return this.latestTimeOfSentByte;
    }

    public void setLatestTimeOfSentByte(long latestTimeOfSentByte) {
        this.latestTimeOfSentByte = latestTimeOfSentByte;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.get() / this.handledPackets.get();
        }
        return 0.0;
    }
}

