/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dkms.gcs.openapi.credential;

import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.darabonba.signature.Signer;
import com.aliyun.dkms.gcs.openapi.credential.models.Config;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaPair;
import com.aliyun.teautil.Common;
import java.io.InputStream;
import java.util.Map;

public class Client {
    public String _keyId;
    public String _privateKeySecret;

    public Client(Config config) throws Exception {
        if (Common.equalString((String)"rsa_key_pair", (String)config.type)) {
            if (!Common.empty((String)config.clientKeyContent)) {
                Object json = Common.parseJSON((String)config.clientKeyContent);
                Map clientKey = Common.assertAsMap((Object)json);
                byte[] privateKeyData = Encoder.base64Decode((String)Common.assertAsString(clientKey.get("PrivateKeyData")));
                this._privateKeySecret = com.aliyun.dkms.gcs.openapi.util.Client.getPrivatePemFromPk12((byte[])privateKeyData, (String)config.password);
                this._keyId = Common.assertAsString(clientKey.get("KeyId"));
            } else if (!Common.empty((String)config.clientKeyFile)) {
                Object jsonFromFile = Common.readAsJSON((InputStream)com.aliyun.darabonba.stream.Client.readFromFilePath((String)config.clientKeyFile));
                if (Common.isUnset((Object)jsonFromFile)) {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)("read client key file failed: " + config.clientKeyFile + ""))}));
                }
                Map clientKeyFromFile = Common.assertAsMap((Object)jsonFromFile);
                byte[] privateKeyDataFromFile = Encoder.base64Decode((String)Common.assertAsString(clientKeyFromFile.get("PrivateKeyData")));
                this._privateKeySecret = com.aliyun.dkms.gcs.openapi.util.Client.getPrivatePemFromPk12((byte[])privateKeyDataFromFile, (String)config.password);
                this._keyId = Common.assertAsString(clientKeyFromFile.get("KeyId"));
            } else {
                this._privateKeySecret = config.privateKey;
                this._keyId = config.accessKeyId;
            }
        } else {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)"Only support rsa key pair credential provider now.")}));
        }
    }

    public String getAccessKeyId() throws Exception {
        return this._keyId;
    }

    public String getAccessKeySecret() throws Exception {
        return this._privateKeySecret;
    }

    public String getSignature(String strToSign) throws Exception {
        String prefix = "Bearer ";
        String sign = Encoder.base64EncodeToString((byte[])Signer.SHA256withRSASign((String)strToSign, (String)this.getAccessKeySecret()));
        return "" + prefix + "" + sign + "";
    }
}

