package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.sdk.gateway.pop.exception.PopClientException;
import com.aliyun.sdk.gateway.pop.exception.PopServerException;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

import java.util.HashMap;
import java.util.Map;

public class TeaResponseInterceptor implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    @Override
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        logger.verbose("HttpResponse process begin.");
        HttpResponse httpResponse = context.httpResponse();
        TeaResponse teaResponse = new TeaResponse();
        teaResponse.setHttpResponse(httpResponse);
        teaResponse.setSuccess(CommonUtil.is2xx(httpResponse.getStatusCode()));
        if (CommonUtil.isNot2xx(httpResponse.getStatusCode())) {
            Object _body = ParseUtil.readAsJSON(httpResponse.getBodyAsString());
            Map<String, Object> err = CommonUtil.assertAsMap(_body);
            Object requestId = CommonUtil.defaultAny(err.get("RequestId"), err.get("requestId"));
            Map<String, Object> errMsg = new HashMap<>();
            errMsg.put("code", CommonUtil.defaultAny(err.get("Code"), err.get("code")));
            errMsg.put("message", "code: " + httpResponse.getStatusCode() + ", " + CommonUtil.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + "");
            errMsg.put("statusCode", httpResponse.getStatusCode());
            errMsg.put("description", CommonUtil.defaultAny(err.get("Description"), err.get("description")));
            errMsg.put("accessDeniedDetail", CommonUtil.defaultAny(err.get("AccessDeniedDetail"), err.get("accessDeniedDetail")));
            errMsg.put("data", err);
            teaResponse.setException(CommonUtil.is5xx(httpResponse.getStatusCode()) ? new PopServerException(errMsg) : new PopClientException(errMsg));
        }
        return teaResponse;
    }
}
