/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbDecoder;
import org.geolatte.geom.codec.WkbDecodeException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.Unit;

public class DmWkbDecoder
extends PostgisWkbDecoder {
    private int srid = -1;

    public DmWkbDecoder() {
    }

    public DmWkbDecoder(int srid) {
        this.srid = srid;
    }

    protected void prepare(ByteBuffer byteBuffer) {
        if (this.srid == -1) {
            this.srid = byteBuffer.getInt();
        }
    }

    protected <P extends Position> CoordinateReferenceSystem<P> readCrs(ByteBuffer byteBuffer, int typeCode, CoordinateReferenceSystem<P> crs) {
        boolean hasZ;
        boolean hasM = (typeCode & 0x40000000) == 0x40000000;
        boolean bl = hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (crs != null) {
            this.validateCrs(crs, hasM, hasZ);
            return crs;
        }
        CoordinateReferenceSystem crsDeclared = CrsRegistry.ifAbsentReturnProjected2D((int)this.srid);
        if (hasZ) {
            crsDeclared = CoordinateReferenceSystems.addVerticalSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        if (hasM) {
            crsDeclared = CoordinateReferenceSystems.addLinearSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        return crsDeclared;
    }

    private void validateCrs(CoordinateReferenceSystem<?> crs, boolean hasM, boolean hasZ) {
        if (hasM && !CoordinateReferenceSystems.hasMeasureAxis(crs) || hasZ && !CoordinateReferenceSystems.hasVerticalAxis(crs)) {
            throw new WkbDecodeException("WKB inconsistent with specified Coordinate Reference System");
        }
    }
}

