package com.easemob.im.server.api.block.user;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.exception.EMInvalidArgumentException;
import com.easemob.im.server.model.EMBlock;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.util.Arrays;

public class SendMsgToUser {
    private Context context;

    public SendMsgToUser(Context context) {
        this.context = context;
    }

    public Flux<EMBlock> getUsersBlocked(String username) {
        return this.context.getHttpClient()
                .get()
                .uri(String.format("/users/%s/blocks/users", username))
                .responseSingle((httpRsp, buf) -> this.context.getErrorMapper().apply(httpRsp).then(buf))
                .map(buf -> this.context.getCodec().decode(buf, GetUsersBlockedSendMsgToUserResponse.class))
                .flatMapIterable(GetUsersBlockedSendMsgToUserResponse::getUsernames)
                .map(blockedUsername -> new EMBlock(blockedUsername, null));
    }

    public Mono<Void> blockUser(String fromUser, String toUser) {
        if (fromUser.equals(toUser)) {
            return Mono.error(new EMInvalidArgumentException("user could not block himself"));
        }
        return this.context.getHttpClient()
                .post()
                .uri(String.format("/users/%s/blocks/users", toUser))
                .send(Mono.create(sink -> sink.success(this.context.getCodec().encode(new BlockUsersSendMsgToUserRequest(Arrays.asList(fromUser))))))
                .response()
                .flatMap(rsp -> this.context.getErrorMapper().apply(rsp).then());
    }

    public Mono<Void> unblockUser(String fromUser, String toUser) {
        return this.context.getHttpClient()
            .delete()
            .uri(String.format("/users/%s/blocks/users/%s", toUser, fromUser))
            .responseSingle((rsp, buf) -> context.getErrorMapper().apply(rsp).then());
    }



}
