/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api;

import com.easemob.im.server.EMException;
import com.easemob.im.server.api.ErrorMapper;
import com.easemob.im.server.exception.EMBadGatewayException;
import com.easemob.im.server.exception.EMBadRequestException;
import com.easemob.im.server.exception.EMForbiddenException;
import com.easemob.im.server.exception.EMGatewayTimeoutException;
import com.easemob.im.server.exception.EMInternalServerErrorException;
import com.easemob.im.server.exception.EMNotFoundException;
import com.easemob.im.server.exception.EMServiceUnavailableException;
import com.easemob.im.server.exception.EMTooManyRequestsException;
import com.easemob.im.server.exception.EMUnauthorizedException;
import com.easemob.im.server.exception.EMUnknownException;
import io.netty.handler.codec.http.HttpResponseStatus;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientResponse;

public class DefaultErrorMapper
implements ErrorMapper {
    @Override
    public Mono<HttpClientResponse> apply(HttpClientResponse response) {
        if (response.status().code() < 400) {
            return Mono.just((Object)response);
        }
        return Mono.error((Throwable)this.toException(response));
    }

    private EMException toException(HttpClientResponse response) {
        String reason = String.format("%s %s -> %d %s", response.method().toString(), response.uri(), response.status().code(), response.status().reasonPhrase());
        HttpResponseStatus status = response.status();
        if (HttpResponseStatus.BAD_REQUEST.equals((Object)status) || HttpResponseStatus.METHOD_NOT_ALLOWED.equals((Object)status) || HttpResponseStatus.NOT_ACCEPTABLE.equals((Object)status) || HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.equals((Object)status)) {
            return new EMBadRequestException(reason);
        }
        if (HttpResponseStatus.UNAUTHORIZED.equals((Object)status)) {
            return new EMUnauthorizedException(reason);
        }
        if (HttpResponseStatus.PAYMENT_REQUIRED.equals((Object)status) || HttpResponseStatus.FORBIDDEN.equals((Object)status)) {
            return new EMForbiddenException(reason);
        }
        if (HttpResponseStatus.NOT_FOUND.equals((Object)status)) {
            return new EMNotFoundException(reason);
        }
        if (HttpResponseStatus.TOO_MANY_REQUESTS.equals((Object)status)) {
            return new EMTooManyRequestsException(reason);
        }
        if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            return new EMInternalServerErrorException(reason);
        }
        if (HttpResponseStatus.BAD_GATEWAY.equals((Object)status)) {
            return new EMBadGatewayException(reason);
        }
        if (HttpResponseStatus.SERVICE_UNAVAILABLE.equals((Object)status)) {
            return new EMServiceUnavailableException(reason);
        }
        if (HttpResponseStatus.GATEWAY_TIMEOUT.equals((Object)status)) {
            return new EMGatewayTimeoutException(reason);
        }
        return new EMUnknownException(reason);
    }
}

