/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.attachment.upload;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.attachment.upload.UploadFileResponse;
import com.easemob.im.server.exception.EMUnknownException;
import com.easemob.im.server.model.EMAttachment;
import io.netty.buffer.ByteBuf;
import java.nio.file.Path;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class Upload {
    private Context context;

    public Upload(Context context) {
        this.context = context;
    }

    public Mono<EMAttachment> fromLocalFile(Path path, boolean restrictAccess) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().headers(headers -> headers.add("restrict-access", (Object)restrictAccess)).post().uri("/chatfiles")).sendForm((req, form) -> form.multipart(true).attr("filename", path.getFileName().toString()).file("file", path.toFile())).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UploadFileResponse.class)).handle((rsp, sink) -> {
            if (rsp.getFiles().isEmpty()) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            String id = rsp.getFiles().get(0).getId();
            String url = rsp.getBaseUrl() + "/" + id;
            String secret = rsp.getFiles().get(0).getSecret();
            sink.next((Object)new EMAttachment(id, url, secret));
        });
    }
}

