/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.block;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.block.group.join.BlockUserJoinGroup;
import com.easemob.im.server.api.block.group.msg.BlockUserSendMsgToGroup;
import com.easemob.im.server.api.block.login.BlockUserLogin;
import com.easemob.im.server.api.block.room.join.BlockUserJoinRoom;
import com.easemob.im.server.api.block.room.msg.block.BlockUserSendMsgToRoom;
import com.easemob.im.server.api.block.room.msg.list.ListUsersBlockedSendMsgToRoom;
import com.easemob.im.server.api.block.room.msg.unblock.UnblockUserSendMsgToRoom;
import com.easemob.im.server.api.block.user.SendMsgToUser;
import com.easemob.im.server.model.EMBlock;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlockApi {
    private SendMsgToUser sendMsgToUser;
    private BlockUserLogin blockUserLogin;
    private BlockUserJoinGroup blockUserJoinGroup;
    private BlockUserJoinRoom blockUserJoinRoom;
    private BlockUserSendMsgToGroup blockUserSendMsgToGroup;
    private UnblockUserSendMsgToRoom unblockUserSendMsgToRoom;
    private BlockUserSendMsgToRoom blockUserSendMsgToRoom;
    private ListUsersBlockedSendMsgToRoom listUsersBlockedSendMsgToRoom;

    public BlockApi(Context context) {
        this.sendMsgToUser = new SendMsgToUser(context);
        this.blockUserLogin = new BlockUserLogin(context);
        this.blockUserJoinGroup = new BlockUserJoinGroup(context);
        this.blockUserJoinRoom = new BlockUserJoinRoom(context);
        this.blockUserSendMsgToGroup = new BlockUserSendMsgToGroup(context);
        this.unblockUserSendMsgToRoom = new UnblockUserSendMsgToRoom(context);
        this.blockUserSendMsgToRoom = new BlockUserSendMsgToRoom(context);
        this.listUsersBlockedSendMsgToRoom = new ListUsersBlockedSendMsgToRoom(context);
    }

    public Flux<EMBlock> getUsersBlockedFromSendMsgToUser(String username) {
        return this.sendMsgToUser.getUsersBlocked(username);
    }

    public Mono<Void> blockUserSendMsgToUser(String fromUser, String toUser) {
        return this.sendMsgToUser.blockUser(fromUser, toUser);
    }

    public Mono<Void> unblockUserSendMsgToUser(String fromUser, String toUser) {
        return this.sendMsgToUser.unblockUser(fromUser, toUser);
    }

    public Mono<Void> blockUserLogin(String username) {
        return this.blockUserLogin.blockUser(username);
    }

    public Mono<Void> unblockUserLogin(String username) {
        return this.blockUserLogin.unblockUser(username);
    }

    public Flux<EMBlock> getUsersBlockedJoinGroup(String groupId) {
        return this.blockUserJoinGroup.getBlockedUsers(groupId);
    }

    public Mono<Void> blockUserJoinGroup(String username, String groupId) {
        return this.blockUserJoinGroup.blockUser(username, groupId);
    }

    public Mono<Void> unblockUserJoinGroup(String username, String groupId) {
        return this.blockUserJoinGroup.unblockUser(username, groupId);
    }

    public Flux<EMBlock> getUsersBlockedJoinRoom(String roomId) {
        return this.blockUserJoinRoom.getBlockedUsers(roomId);
    }

    public Mono<Void> blockUserJoinRoom(String username, String roomId) {
        return this.blockUserJoinRoom.blockUser(username, roomId);
    }

    public Mono<Void> unblockUserJoinRoom(String username, String roomId) {
        return this.blockUserJoinRoom.unblockUser(username, roomId);
    }

    public Flux<EMBlock> getUsersBlockedSendMsgToGroup(String groupId) {
        return this.blockUserSendMsgToGroup.getBlockedUsers(groupId);
    }

    public Mono<Void> blockUserSendMsgToGroup(String username, String groupId, Duration duration) {
        return this.blockUserSendMsgToGroup.blockUser(username, groupId, duration);
    }

    public Mono<Void> unblockUserSendMsgToGroup(String username, String groupId) {
        return this.blockUserSendMsgToGroup.unblockUser(username, groupId);
    }

    public Flux<EMBlock> listUsersBlockedSendMsgToRoom(String roomId) {
        return this.listUsersBlockedSendMsgToRoom.all(roomId);
    }

    public Mono<Void> blockUserSendMsgToRoom(String username, String roomId, Duration duration) {
        return this.blockUserSendMsgToRoom.single(username, roomId, duration);
    }

    public Mono<Void> unblockUserSendMsgToRoom(String username, String roomId) {
        return this.unblockUserSendMsgToRoom.single(username, roomId);
    }
}

